/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.util;

import ch.njol.skript.Skript;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;

public class Remover {
    private final String VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    private final Map<?, Map<?, ?>> recipeMap;
    private Method getMCKey;
    private Class<?> CB_KEY;

    public Remover() {
        try {
            this.CB_KEY = this.getCBClass("util.CraftNamespacedKey");
            this.getMCKey = this.CB_KEY.getDeclaredMethod("toMinecraft", NamespacedKey.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Skript.warning((String)"[SkRecipe] - Recipe remover failed to load!");
        }
        this.recipeMap = this.getRecipeMap();
    }

    public void removeRecipeByKey(NamespacedKey recipeKey) {
        Object key;
        try {
            key = this.getMCKey.invoke(this.CB_KEY, recipeKey);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Skript.error((String)("Recipe cant be removed: " + recipeKey.toString()));
            return;
        }
        this.recipeMap.values().forEach(recipes -> recipes.entrySet().removeIf(entry -> entry.getKey().equals(key)));
    }

    public void removeAll() {
        this.recipeMap.values().forEach(recipes -> recipes.entrySet().removeIf(entry -> entry.getKey().toString().contains("minecraft:")));
    }

    private Map<?, Map<?, ?>> getRecipeMap() {
        try {
            Class<?> CRAFT_SERVER = this.getCBClass("CraftServer");
            Method getServer = CRAFT_SERVER.getMethod("getServer", new Class[0]);
            Object dediServer = getServer.invoke((Object)Bukkit.getServer(), new Object[0]);
            Class<?> DEDI_SERVER = this.getNMSClass("DedicatedServer");
            Method getCraftingManager = DEDI_SERVER.getMethod("getCraftingManager", new Class[0]);
            Object craftingManager = getCraftingManager.invoke(dediServer, new Object[0]);
            Class<?> CRAFTING_MANAGER = this.getNMSClass("CraftingManager");
            Field recipeField = CRAFTING_MANAGER.getField("recipes");
            return (Map)recipeField.get(craftingManager);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Class<?> getNMSClass(String nmsClassString) throws ClassNotFoundException {
        String name = "net.minecraft.server." + this.VERSION + "." + nmsClassString;
        return Class.forName(name);
    }

    private Class<?> getCBClass(String cbClassString) throws ClassNotFoundException {
        String name = "org.bukkit.craftbukkit." + this.VERSION + "." + cbClassString;
        return Class.forName(name);
    }
}

