/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.StructureBee;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.util.BlockVector;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - Fill")
@Description(value={"Fill a structure with blocks. Requires MC 1.17.1+"})
@Examples(value={"fill structure {_s} between {loc1} and {loc2}", "fill structure {_s} between location at player and location(10,10,10, world \"world\")"})
@Since(value="1.12.0")
public class EffStructureFill
extends Effect {
    private Expression<StructureBee> structure;
    private Expression<Location> loc1;
    private Expression<Location> loc2;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.structure = exprs[0];
        this.loc1 = exprs[1];
        this.loc2 = exprs[2];
        return true;
    }

    protected void execute(Event e) {
        StructureBee structure = (StructureBee)this.structure.getSingle(e);
        Location loc1 = (Location)this.loc1.getSingle(e);
        Location loc2 = (Location)this.loc2.getSingle(e);
        if (structure == null || loc1 == null || loc2 == null) {
            return;
        }
        if (loc1.getWorld() != loc2.getWorld()) {
            return;
        }
        World world = loc1.getWorld();
        int x = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        Location low = new Location(world, (double)x, (double)y, (double)z);
        int xDiff = Math.max(loc1.getBlockX(), loc2.getBlockX()) + 1 - x;
        int yDiff = Math.max(loc1.getBlockY(), loc2.getBlockY()) + 1 - y;
        int zDiff = Math.max(loc1.getBlockZ(), loc2.getBlockZ()) + 1 - z;
        BlockVector offset = new BlockVector(xDiff, yDiff, zDiff);
        structure.fill(low, offset);
    }

    public String toString(@Nullable Event e, boolean d) {
        return String.format("fill structure %s between %s and %s", this.structure.toString(e, d), this.loc1.toString(e, d), this.loc2.toString(e, d));
    }

    static {
        if (Skript.classExists((String)"org.bukkit.structure.Structure")) {
            Skript.registerEffect(EffStructureFill.class, (String[])new String[]{"fill [structure] %structure% between %location% and %location%"});
        }
    }
}

