/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.StructureBee;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - Place")
@Description(value={"Place an already created structure into the world. Requires MC 1.17.1+"})
@Examples(value={"place structure {_s} at location above target block of player"})
@Since(value="1.12.0")
public class EffStructurePlace
extends Effect {
    private Expression<StructureBee> structure;
    private Expression<Location> location;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.structure = exprs[0];
        this.location = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        StructureBee structure = (StructureBee)this.structure.getSingle(e);
        Location location = (Location)this.location.getSingle(e);
        if (structure == null || location == null) {
            return;
        }
        structure.place(location);
    }

    public String toString(@Nullable Event e, boolean d) {
        return "paste " + this.structure.toString(e, d) + " at " + this.location.toString(e, d);
    }

    static {
        if (Skript.classExists((String)"org.bukkit.structure.Structure")) {
            Skript.registerEffect(EffStructurePlace.class, (String[])new String[]{"place [structure] %structure% at %location%"});
        }
    }
}

