/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.StructureBee;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - Save")
@Description(value={"Save a structure to file. Will overwrite if already in that file. Requires MC 1.17.1+"})
@Examples(value={"save structure {_s}", "save structures {_s::*}"})
@Since(value="1.12.0")
public class EffStructureSave
extends Effect {
    private Expression<StructureBee> structures;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.structures = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        for (StructureBee structureBee : (StructureBee[])this.structures.getAll(e)) {
            structureBee.save();
        }
    }

    public String toString(@Nullable Event e, boolean d) {
        return "save structure[s] " + this.structures.toString(e, d);
    }

    static {
        if (Skript.classExists((String)"org.bukkit.structure.Structure")) {
            Skript.registerEffect(EffStructureSave.class, (String[])new String[]{"save [structure[s]] %structures%"});
        }
    }
}

