/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.BlockStateBee;
import java.util.ArrayList;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockState - BlockData")
@Description(value={"Represents the blockdata of a block in a structure. Requires MC 1.17.1+"})
@Examples(value={"set {_data} to blockdata of blockstate {_blockstate}"})
@Since(value="1.12.3")
public class ExprBlockStateBlockData
extends SimpleExpression<BlockData> {
    private Expression<BlockStateBee> blockState;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blockState = exprs[0];
        return true;
    }

    @Nullable
    protected BlockData[] get(Event e) {
        ArrayList<BlockData> blockDatas = new ArrayList<BlockData>();
        for (BlockStateBee blockState : (BlockStateBee[])this.blockState.getAll(e)) {
            blockDatas.add(blockState.getBlockData());
        }
        return blockDatas.toArray(new BlockData[0]);
    }

    public boolean isSingle() {
        return this.blockState.isSingle();
    }

    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "blockdata of blockstate[s] " + this.blockState.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBlockStateBlockData.class, BlockData.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"block[ ]data of [blockstate[s]] %blockstates%"});
    }
}

