/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.BlockStateBee;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockState - ItemType")
@Description(value={"Represents the itemtype of a block in a structure. Requires MC 1.17.1+"})
@Examples(value={"set {_type} to itemtype of blockstate {_blockstate}"})
@Since(value="1.12.3")
public class ExprBlockStateItemType
extends SimpleExpression<ItemType> {
    private Expression<BlockStateBee> blockState;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blockState = exprs[0];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event e) {
        ArrayList<ItemType> itemTypes = new ArrayList<ItemType>();
        for (BlockStateBee blockState : (BlockStateBee[])this.blockState.getAll(e)) {
            itemTypes.add(blockState.getItemType());
        }
        return itemTypes.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return this.blockState.isSingle();
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "itemtype of blockstate[s] " + this.blockState.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBlockStateItemType.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[item[ ]]type of [blockstate[s]] %blockstates%"});
    }
}

