/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.BlockStateBee;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockState - Offset")
@Description(value={"Represents the offset of a block in a structure. This is a vector, distance from the starting block of a structure.", "Requires MC 1.17.1+"})
@Examples(value={"set {_offset} to offset of blockstate {_blockstate}"})
@Since(value="1.12.3")
public class ExprBlockStateOffset
extends SimpleExpression<Vector> {
    private Expression<BlockStateBee> blockstate;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blockstate = exprs[0];
        return true;
    }

    @Nullable
    protected Vector[] get(Event e) {
        ArrayList<Vector> offsets = new ArrayList<Vector>();
        for (BlockStateBee blockState : (BlockStateBee[])this.blockstate.getAll(e)) {
            offsets.add(blockState.getOffset());
        }
        return offsets.toArray(new Vector[0]);
    }

    public boolean isSingle() {
        return this.blockstate.isSingle();
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "offset of blockstate " + this.blockstate.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBlockStateOffset.class, Vector.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"offset of [blockstate[s]] %blockstates%"});
    }
}

