/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.BlockStateBee;
import com.shanebeestudios.skbee.api.structure.StructureBee;
import java.util.ArrayList;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.structure.Palette;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - BlockStates")
@Description(value={"Get a list of the blockstates in a structure. This represents the palette of blocks a structure holds.", "Requires MC 1.17.1+"})
@Examples(value={"set {_list::*} to blockstates of structure {_structure}"})
@Since(value="1.12.3")
public class ExprStructureBlockStates
extends SimpleExpression<BlockStateBee> {
    private Expression<StructureBee> structure;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.structure = exprs[0];
        return true;
    }

    @Nullable
    protected BlockStateBee[] get(Event e) {
        StructureBee structure = (StructureBee)this.structure.getSingle(e);
        if (structure != null) {
            ArrayList blocks = new ArrayList();
            ((Palette)structure.getBukkitStructure().getPalettes().get(0)).getBlocks().forEach(state -> blocks.add(new BlockStateBee((BlockState)state)));
            return blocks.toArray(new BlockStateBee[0]);
        }
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends BlockStateBee> getReturnType() {
        return BlockStateBee.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "blockstates of structure " + this.structure.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprStructureBlockStates.class, BlockStateBee.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"blockstates of [structure] %structure%"});
    }
}

