/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.structure.StructureBee;
import com.shanebeestudios.skbee.api.structure.StructureBeeManager;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - Object")
@Description(value={"Create a new, empty structure or load a structure from file. ", "If the file you have specified is not available, it will be created upon saving.", "Structures without a namespace (ex: \"tree\") will load from/save to \"(main world folder)/generated/minecraft/structures/\".", "Structures with a namespace (ex:\"myname:house\") will load from/save to \"(main world folder)/generated/myname/structures/\".", "To create folders, simply add a slash in your name, ex: \"buildings/house\".", "Requires MC 1.17.1+"})
@Examples(value={"set {_s} to structure named \"my-server:houses/house1\"", "set {_s} to structure named \"my-house\"", "set {_s::*} to structures named \"house1\" and \"house2\""})
@Since(value="1.12.0")
public class ExprStructureObject
extends SimpleExpression<StructureBee> {
    private static final StructureBeeManager STRUCTURE_BEE_MANAGER;
    private Expression<String> fileString;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.fileString = exprs[0];
        return true;
    }

    @Nullable
    protected StructureBee[] get(Event e) {
        ArrayList<StructureBee> structures = new ArrayList<StructureBee>();
        for (String file : (String[])this.fileString.getAll(e)) {
            if (!$assertionsDisabled && STRUCTURE_BEE_MANAGER == null) {
                throw new AssertionError();
            }
            structures.add(STRUCTURE_BEE_MANAGER.getStructure(file));
        }
        return structures.toArray(new StructureBee[0]);
    }

    public boolean isSingle() {
        return this.fileString.isSingle();
    }

    public Class<? extends StructureBee> getReturnType() {
        return StructureBee.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "structure[s] named " + this.fileString.toString(e, d);
    }

    static {
        boolean bl = $assertionsDisabled = !ExprStructureObject.class.desiredAssertionStatus();
        if (Skript.classExists((String)"org.bukkit.structure.Structure")) {
            STRUCTURE_BEE_MANAGER = SkBee.getPlugin().getStructureBeeManager();
            Skript.registerExpression(ExprStructureObject.class, StructureBee.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"structure[s] named %strings%"});
        } else {
            STRUCTURE_BEE_MANAGER = null;
        }
    }
}

