/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structureold.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesMap;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.structure.api.bukkit.StructureBlockLibApi;
import com.shanebeestudios.skbee.api.structure.api.enumeration.StructureRestriction;
import com.shanebeestudios.skbee.api.util.Util;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure Block - Save")
@Description(value={"Save structure block structures.", "Requires Minecraft 1.9.4+. No longer available on MC 1.18+, please use new structure system."})
@Examples(value={"save structure between {loc1} and {loc2} as \"house\""})
@Since(value="1.0.0")
public class EffSaveStructure
extends Effect {
    private static final String WORLD;
    private static final StructureBlockLibApi STRUCTURE_API;
    private static final boolean HAS_NEW_STRUCTURE_API;
    private Expression<Location> loc1;
    private Expression<Location> loc2;
    private Expression<String> name;

    public boolean init(Expression<?> @NotNull [] exprs, int i, @NotNull Kleenean kleenean, @NotNull SkriptParser.ParseResult parseResult) {
        this.loc1 = exprs[0];
        this.loc2 = exprs[1];
        this.name = exprs[2];
        if (HAS_NEW_STRUCTURE_API) {
            Util.skriptError("This effect is deprecated and will be removed in the future. Please use the new structure system.");
        }
        return true;
    }

    protected void execute(@NotNull Event event) {
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        this.debug(event, true);
        TriggerItem next = this.getNext();
        Delay.addDelayedEvent((Event)event);
        Location loc1 = (Location)this.loc1.getSingle(event);
        Location loc2 = (Location)this.loc2.getSingle(event);
        if (loc1 == null || loc2 == null) {
            return next;
        }
        World world = loc1.getWorld();
        int x = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        Location low = new Location(world, (double)x, (double)y, (double)z);
        int xDiff = Math.max(loc1.getBlockX(), loc2.getBlockX()) + 1 - x;
        int yDiff = Math.max(loc1.getBlockY(), loc2.getBlockY()) + 1 - y;
        int zDiff = Math.max(loc1.getBlockZ(), loc2.getBlockZ()) + 1 - z;
        String name = (String)this.name.getSingle(event);
        VariablesMap localVars = Variables.removeLocals((Event)event);
        STRUCTURE_API.saveStructure((Plugin)SkBee.getPlugin()).restriction(StructureRestriction.UNLIMITED).at(low).sizeX(xDiff).sizeY(yDiff).sizeZ(zDiff).includeEntities(true).saveToWorld(WORLD, "minecraft", name).onException(e -> {
            Skript.error((String)("Could not save structure: " + name));
            if (SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG) {
                e.printStackTrace();
            }
            this.continueWalk(next, event, localVars);
        }).onResult(e -> this.continueWalk(next, event, localVars));
        return null;
    }

    private void continueWalk(@Nullable TriggerItem next, Event event, Object localVars) {
        if (localVars != null) {
            Variables.setLocalVariables((Event)event, (Object)localVars);
        }
        Object timing = null;
        if (next != null) {
            Trigger trigger;
            if (SkriptTimings.enabled() && (trigger = this.getTrigger()) != null) {
                timing = SkriptTimings.start((String)trigger.getDebugLabel());
            }
            TriggerItem.walk((TriggerItem)next, (Event)event);
        }
        Variables.removeLocals((Event)event);
        SkriptTimings.stop(timing);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return String.format("save structure between %s and %s as %s", this.loc1.toString(e, d), this.loc2.toString(e, d), this.name.toString(e, d));
    }

    static {
        STRUCTURE_API = StructureBlockLibApi.INSTANCE;
        HAS_NEW_STRUCTURE_API = Skript.classExists((String)"org.bukkit.structure.Structure");
        String worldContainer = Bukkit.getWorldContainer().getPath();
        String worldName = ((World)Bukkit.getWorlds().get(0)).getName();
        WORLD = worldContainer.equalsIgnoreCase(".") ? worldName : worldContainer + File.separator + worldName;
        Skript.registerEffect(EffSaveStructure.class, (String[])new String[]{"save [structure] between %location% and %location% as %string%"});
    }
}

