/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Send")
@Description(value={"Send text components to players (or console, not sure which server version this started on). ", "The optional sender (supported in Minecraft 1.16.4+) allows you to send components from a specific player.", "This is useful to make sure players can block messages using 1.16.4's new player chat ignore system."})
@Examples(value={"set {_comp::1} to text component of \"hi player \"", "set {_comp::2} to text component of \"hover over me for a special message!\"", "set hover event of {_comp::2} to hover event to show \"OoO look ma I'm hovering!\"", "send component {_comp::*} to player"})
@Since(value="1.5.0")
public class EffSendComponent
extends Effect {
    private static final boolean SUPPORTS_COMMAND_SENDER = Skript.classExists((String)"org.bukkit.command.CommandSender$Spigot");
    private static final boolean SUPPORTS_SENDER;
    private Expression<BaseComponent> components;
    private Expression<CommandSender> players;
    @Nullable
    private Expression<Player> sender;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.components = exprs[0];
        this.players = exprs[1];
        this.sender = SUPPORTS_SENDER ? exprs[2] : null;
        return true;
    }

    protected void execute(Event e) {
        if (this.components == null || this.players == null) {
            return;
        }
        Player sender = this.sender != null ? (Player)this.sender.getSingle(e) : null;
        BaseComponent[] components = (BaseComponent[])this.components.getArray(e);
        for (CommandSender player : (CommandSender[])this.players.getArray(e)) {
            this.sendMessage(player, sender, components);
        }
    }

    private void sendMessage(CommandSender receiver, Player sender, BaseComponent ... components) {
        if (SUPPORTS_SENDER && sender != null) {
            receiver.spigot().sendMessage(sender.getUniqueId(), components);
        } else if (SUPPORTS_COMMAND_SENDER) {
            receiver.spigot().sendMessage(components);
        } else if (receiver instanceof Player) {
            ((Player)receiver).spigot().sendMessage(components);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return String.format("send component[s] %s to %s %s", this.components.toString(e, d), this.players.toString(e, d), this.sender != null ? "from " + this.sender.toString(e, d) : "");
    }

    static {
        boolean bl = SUPPORTS_SENDER = SUPPORTS_COMMAND_SENDER && Skript.methodExists(CommandSender.Spigot.class, (String)"sendMessage", (Class[])new Class[]{UUID.class, BaseComponent.class});
        if (SUPPORTS_SENDER) {
            Skript.registerEffect(EffSendComponent.class, (String[])new String[]{"send [text] component[s] %basecomponents% [to %commandsenders%] [from %-player%]"});
        } else if (SUPPORTS_COMMAND_SENDER) {
            Skript.registerEffect(EffSendComponent.class, (String[])new String[]{"send [text] component[s] %basecomponents% [to %commandsenders%]"});
        } else {
            Skript.registerEffect(EffSendComponent.class, (String[])new String[]{"send [text] component[s] %basecomponents% [to %players%]"});
        }
    }
}

