/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Name(value="Book Pages")
@Description(value={"Allows you to set pages in a book to text components. You can also retrieve the pages. Based on testing, a book's author/title needs to be set AFTER setting the pages, why? I have no idea!"})
@Examples(value={"set {_i} to a written book", "set {_a} to text component of \"RULES\"", "set hover event of {_a} to hover event showing \"make sure to read our rules\"", "set click event of {_a} to click event to run command \"/rules\"", "set page 1 of {_i} to {_a}", "set book author of {_i} to \"Bob\"", "set book title of {_i} to \"MyBook\"", "give player 1 of {_i}"})
@Since(value="1.8.0")
public class ExprBookPages
extends SimpleExpression<BaseComponent> {
    private final ItemType BOOK = Aliases.javaItemType((String)"book with text");
    private Expression<ItemType> item;
    private Expression<Number> page;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.item = exprs[1];
        this.page = exprs[0];
        return true;
    }

    @Nullable
    protected BaseComponent[] get(@NotNull Event e) {
        ItemType item = (ItemType)this.item.getSingle(e);
        if (item == null) {
            return null;
        }
        Material material = item.getMaterial();
        if (this.BOOK.isOfType(material)) {
            int page;
            BookMeta bookMeta = (BookMeta)item.getItemMeta();
            Number num = (Number)this.page.getSingle(e);
            int n = page = num == null ? 0 : num.intValue();
            if (bookMeta.getPages().size() >= page) {
                return bookMeta.spigot().getPage(page);
            }
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{BaseComponent[].class});
        }
        return null;
    }

    public void change(@NotNull Event e, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        BaseComponent[] baseComponents = delta == null ? null : (BaseComponent[])delta;
        ItemType book = (ItemType)this.item.getSingle(e);
        if (book == null) {
            return;
        }
        Material bookMaterial = book.getMaterial();
        if (this.BOOK.isOfType(bookMaterial)) {
            int p;
            BookMeta bookMeta = (BookMeta)book.getItemMeta();
            Number page = (Number)this.page.getSingle(e);
            int n = p = page != null ? page.intValue() : 0;
            if (bookMeta.spigot().getPages().size() < p) {
                bookMeta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{baseComponents});
            } else {
                bookMeta.spigot().setPage(p, baseComponents);
            }
            book.setItemMeta((ItemMeta)bookMeta);
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends BaseComponent> getReturnType() {
        return BaseComponent.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "page " + this.page.toString(e, d) + " of book " + this.item.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBookPages.class, BaseComponent.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"page %number% of [book] %itemtype%"});
    }
}

