/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.event.Event;

@Name(value="Text Component - Click Event")
@Description(value={"Create a new click event. Supports run command, suggest command, open link and copy to clipboard."})
@Examples(value={"set {_t} to text component from \"Check out my cool website\"", "set hover event of {_t} to a new hover event showing \"Clicky clicky to go to spawn!\"", "set click event of {_t} to a new click event to open url \"https://my.cool.website\"", "send component {_t} to player"})
@Since(value="1.5.0")
public class ExprClickEvent
extends SimpleExpression<ClickEvent> {
    private static final boolean SUPPORTS_CLIPBOARD = Skript.fieldExists(ClickEvent.Action.class, (String)"COPY_TO_CLIPBOARD");
    private int pattern;
    private Expression<Object> object;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 3 && !SUPPORTS_CLIPBOARD) {
            Skript.error((String)"'click event to copy %string% to clipboard' is not supported on your server version", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.object = exprs[0];
        return true;
    }

    @Nullable
    protected ClickEvent[] get(Event e) {
        ClickEvent.Action action;
        if (this.object == null) {
            return null;
        }
        Object value = this.object.getSingle(e);
        switch (this.pattern) {
            case 1: {
                action = ClickEvent.Action.SUGGEST_COMMAND;
                break;
            }
            case 2: {
                action = ClickEvent.Action.OPEN_URL;
                break;
            }
            case 3: {
                action = ClickEvent.Action.COPY_TO_CLIPBOARD;
                break;
            }
            case 4: {
                action = ClickEvent.Action.CHANGE_PAGE;
                value = "" + ((Number)this.object.getSingle(e)).intValue();
                break;
            }
            default: {
                action = ClickEvent.Action.RUN_COMMAND;
            }
        }
        return new ClickEvent[]{new ClickEvent(action, (String)value)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ClickEvent> getReturnType() {
        return ClickEvent.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        String[] actions = new String[]{"run command", "suggest command", "open url", "copy to clipboard", "change to page"};
        return "click event to " + actions[this.pattern] + " " + this.object.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprClickEvent.class, ClickEvent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] click event to run command %string%", "[a] [new] click event to suggest command %string%", "[a] [new] click event to open (link|url) %string%", "[a] [new] click event to copy %string% to clipboard", "[a] [new] click event to change to page %number%"});
    }
}

