/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Text Component - Hover Event Of")
@Description(value={"Set the hover event of a text component."})
@Examples(value={"set {_t} to text component from \"Check out my cool tool!\"", "set hover event of {_t} to a new hover event showing player's tool", "send component {_t} to player"})
@Since(value="1.5.0")
public class ExprHoverEventOf
extends PropertyExpression<BaseComponent, HoverEvent> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected HoverEvent @NotNull [] get(Event e, BaseComponent[] source) {
        return (HoverEvent[])this.get(source, BaseComponent::getHoverEvent);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{HoverEvent.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        HoverEvent hoverEvent;
        HoverEvent hoverEvent2 = hoverEvent = delta != null ? (HoverEvent)delta[0] : null;
        if (hoverEvent == null) {
            return;
        }
        for (BaseComponent component : (BaseComponent[])this.getExpr().getArray(e)) {
            component.setHoverEvent(hoverEvent);
        }
    }

    @NotNull
    public Class<? extends HoverEvent> getReturnType() {
        return HoverEvent.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "hover event of " + this.getExpr().toString(e, d);
    }

    static {
        ExprHoverEventOf.register(ExprHoverEventOf.class, HoverEvent.class, (String)"hover event", (String)"basecomponents");
    }
}

