/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.NBT.NBTApi;
import com.shanebeestudios.skbee.api.NBT.NBTContainer;
import com.shanebeestudios.skbee.api.reflection.McReflection;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;

@Name(value="Text Component - New Text Component")
@Description(value={"Create a new text component. Can have hover and click events added to it. You can also create a translate component, ", "this will send to the client, and the client will translate based on their language. You can use either an item type or a ", "translate string, you can find these in your Minecraft jar 'assets/minecraft/lang/<lang file>.json'.", "Some components have extra objects, you can use strings or other text components here."})
@Examples(value={"set {_comp::1} to text component from \"hi player \"", "set {_comp::2} to text component of \"hover over me for a special message!\"", "set hover event of {_comp::2} to hover event to show \"OoO look ma I'm hovering!\"", "send component {_comp::*} to player", "", "set {_t} to translate component from player's tool", "set {_t} to translate component from \"item.minecraft.milk_bucket\"", "set {_death} to translate component from \"death.fell.accident.ladder\" using player's name", "set {_assist} to translate component \"death.fell.assist\" using victim's name and attacker's name"})
@Since(value="1.5.0")
public class ExprTextComponent
extends SimpleExpression<BaseComponent> {
    private static final NBTApi api = SkBee.getPlugin().getNbtApi();
    private int pattern;
    private Expression<Object> translation;
    private Expression<Object> objects;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.translation = exprs[0];
        this.objects = this.pattern == 2 ? exprs[1] : null;
        return true;
    }

    @Nullable
    protected BaseComponent[] get(@NotNull Event e) {
        ArrayList<Object> components = new ArrayList<Object>();
        for (Object object : this.translation.getArray(e)) {
            if (this.pattern == 0) {
                BaseComponent[] baseComponents = TextComponent.fromLegacyText((String)Util.getColString((String)object));
                components.add(new TextComponent(baseComponents));
                continue;
            }
            if (this.pattern == 1) {
                String translate;
                if (object instanceof ItemType) {
                    ItemType itemType = (ItemType)object;
                    translate = this.translate(itemType);
                } else {
                    translate = (String)object;
                }
                components.add(new TranslatableComponent(translate, new Object[0]));
                continue;
            }
            String string = (String)this.translation.getSingle(e);
            Object[] objects = this.objects.getAll(e);
            components.add(new TranslatableComponent(string, objects));
        }
        return components.toArray(new BaseComponent[0]);
    }

    public boolean isSingle() {
        return this.translation.isSingle();
    }

    @NotNull
    public Class<? extends BaseComponent> getReturnType() {
        return BaseComponent.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "a new text component from " + this.translation.toString(e, d);
    }

    private String translate(ItemType itemType) {
        ItemStack itemStack = itemType.getRandom();
        assert (itemStack != null);
        String trans = McReflection.getTranslateKey(itemStack);
        if (trans != null) {
            return trans;
        }
        Material material = itemStack.getType();
        String type = material.isBlock() ? "block" : "item";
        String raw = ((String)itemType.getRawNames().get(0)).replace("minecraft:", "");
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof PotionMeta) {
            String pot;
            StringBuilder builder = new StringBuilder("item.minecraft.");
            String nbt = api.getNBT(itemType, NBTApi.ObjectType.ITEM_TYPE);
            if (nbt != null && (pot = api.getTag("Potion", new NBTContainer(nbt)).toString()) != null) {
                if (material == Material.POTION) {
                    builder.append("potion");
                } else if (material == Material.SPLASH_POTION) {
                    builder.append("splash_potion");
                } else if (material == Material.LINGERING_POTION) {
                    builder.append("lingering_potion");
                } else if (material == Material.TIPPED_ARROW) {
                    builder.append("tipped_arrow");
                }
                builder.append(".effect.").append(pot.replace("minecraft:", ""));
                return builder.toString();
            }
        }
        return type + ".minecraft." + raw;
    }

    static {
        Skript.registerExpression(ExprTextComponent.class, BaseComponent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] text component[s] (from|of) %strings%", "[a] [new] translate component[s] (from|of) %itemtypes/strings%", "[a] [new] translate component[s] (from|of) %string% (with|using) %objects%"});
    }
}

