/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldConfig;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldCreator;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Load/Unload/Delete World")
@Description(value={"Load a world from a world creator. Worlds created/loaded with a world creator, are saved in the 'plugins/SkBee/worlds.yml' file and automatically loaded on server start. If you wish to import a world, just use a world creator with a name that matches that world folder.You can load a world from a name (assuming this world is in your world directory and not loaded. You can unload a world with an option to save/not save (defaults to saving). You can also delete a world, but only a custom world."})
@Examples(value={"set {_w} to a new world creator named \"my-world\"", "load world from world creator {_w}", "", "load world \"my-world\"", "unload world world(\"my-world\")"})
@Since(value="1.8.0")
public class EffLoadWorld
extends Effect {
    private static final BeeWorldConfig BEE_WORLD_CONFIG = SkBee.getPlugin().getBeeWorldConfig();
    private int pattern;
    private Expression<BeeWorldCreator> creator;
    private Expression<String> worldName;
    private Expression<World> world;
    private boolean save;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.creator = this.pattern == 0 ? exprs[0] : null;
        this.worldName = this.pattern == 1 || this.pattern == 3 ? exprs[0] : null;
        this.world = this.pattern == 2 ? exprs[0] : null;
        this.save = this.pattern == 2 && parseResult.mark != 1;
        return true;
    }

    protected void execute(@NotNull Event e) {
        if (this.pattern == 0) {
            BeeWorldCreator worldCreator = (BeeWorldCreator)this.creator.getSingle(e);
            if (worldCreator != null) {
                worldCreator.loadWorld();
            }
        } else if (this.pattern == 1) {
            if (this.worldName == null) {
                return;
            }
            String worldName = (String)this.worldName.getSingle(e);
            if (worldName == null) {
                return;
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                new WorldCreator(worldName).createWorld();
            }
        } else if (this.pattern == 2) {
            if (this.world == null) {
                return;
            }
            World world = (World)this.world.getSingle(e);
            if (world == null) {
                return;
            }
            this.unloadWorld(world);
        } else if (this.pattern == 3) {
            if (this.worldName == null) {
                return;
            }
            String worldName = (String)this.worldName.getSingle(e);
            if (worldName == null) {
                return;
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world != null && !this.unloadWorld(world)) {
                return;
            }
            BEE_WORLD_CONFIG.deleteWorld((String)this.worldName.getSingle(e));
        }
    }

    private boolean unloadWorld(@NotNull World world) {
        Object mainWorld = (World)Bukkit.getWorlds().get(0);
        if (world == mainWorld) {
            mainWorld = Bukkit.getWorlds().size() > 1 ? (World)Bukkit.getWorlds().get(1) : null;
        }
        if (mainWorld != null) {
            World finalMainWorld = mainWorld;
            world.getPlayers().forEach(player -> player.teleport(finalMainWorld.getSpawnLocation()));
        }
        return Bukkit.unloadWorld((World)world, (boolean)this.save);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        switch (this.pattern) {
            case 1: {
                return String.format("load world %s", this.worldName.toString(e, d));
            }
            case 2: {
                String save = this.save ? "and save" : "without saving";
                return String.format("unload world %s %s", this.world.toString(e, d), save);
            }
            case 3: {
                return String.format("delete world file for %s", this.worldName.toString(e, d));
            }
        }
        return String.format("load world from creator %s", this.creator.toString(e, d));
    }

    static {
        Skript.registerEffect(EffLoadWorld.class, (String[])new String[]{"load world from [[world] creator] %worldcreator%", "load world %string%", "unload [world] %world% [and (0\u00a6save|1\u00a6(do not|don't) save)]", "delete world file for [world] %string%"});
    }
}

