/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldCreator;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="World Creator Options")
@Description(value={"Set different options for world creators. See SkBee wiki for more details."})
@Examples(value={"set {_w} to a new world creator named \"my-world\"", "set environment of {_w} to nether", "set world type of {_w} to flat", "set should generate structures of {_w} to true", "load world from creator {_w}"})
@Since(value="1.8.0")
public class ExprWorldCreatorOption
extends SimplePropertyExpression<BeeWorldCreator, Object> {
    private int pattern;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.setExpr(exprs[0]);
        return true;
    }

    @Nullable
    public Object convert(@NotNull BeeWorldCreator creator) {
        switch (this.pattern) {
            case 1: {
                return creator.getWorldType();
            }
            case 2: {
                return creator.getSeed();
            }
            case 3: {
                return creator.getGeneratorSettings();
            }
            case 4: {
                return creator.getGenerator();
            }
            case 5: {
                return creator.isGenStructures();
            }
            case 6: {
                return creator.isHardcore();
            }
            case 7: {
                return creator.isKeepSpawnLoaded();
            }
        }
        return creator.getEnvironment();
    }

    @Nullable
    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            switch (this.pattern) {
                case 1: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{WorldType.class});
                }
                case 2: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
                }
                case 3: 
                case 4: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
                }
                case 5: 
                case 6: 
                case 7: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
                }
            }
            return (Class[])CollectionUtils.array((Object[])new Class[]{World.Environment.class});
        }
        return null;
    }

    public void change(@NotNull Event event, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        Object object = delta != null ? delta[0] : null;
        BeeWorldCreator creator = (BeeWorldCreator)this.getExpr().getSingle(event);
        if (creator == null) {
            return;
        }
        switch (this.pattern) {
            case 1: {
                if (!(object instanceof WorldType)) break;
                creator.setWorldType((WorldType)object);
                break;
            }
            case 2: {
                if (!(object instanceof Number)) break;
                creator.setSeed(((Number)object).longValue());
                break;
            }
            case 3: {
                if (!(object instanceof String)) break;
                creator.setGeneratorSettings((String)object);
                break;
            }
            case 4: {
                if (!(object instanceof String)) break;
                creator.setGenerator((String)object);
                break;
            }
            case 5: {
                if (!(object instanceof Boolean)) break;
                creator.setGenStructures((Boolean)object);
                break;
            }
            case 6: {
                if (!(object instanceof Boolean)) break;
                creator.setHardcore((Boolean)object);
                break;
            }
            case 7: {
                if (!(object instanceof Boolean)) break;
                creator.setKeepSpawnLoaded((Boolean)object);
                break;
            }
            default: {
                if (!(object instanceof World.Environment)) break;
                creator.setEnvironment((World.Environment)object);
            }
        }
    }

    @NotNull
    public Class<?> getReturnType() {
        switch (this.pattern) {
            case 1: {
                return WorldType.class;
            }
            case 2: {
                return Number.class;
            }
            case 3: 
            case 4: {
                return String.class;
            }
            case 5: 
            case 6: 
            case 7: {
                return Boolean.class;
            }
        }
        return World.Environment.class;
    }

    @NotNull
    protected String getPropertyName() {
        switch (this.pattern) {
            case 1: {
                return "world type";
            }
            case 2: {
                return "seed";
            }
            case 3: {
                return "generator settings";
            }
            case 4: {
                return "generator";
            }
            case 5: {
                return "should generate structures";
            }
            case 6: {
                return "hardcore";
            }
            case 7: {
                return "keep spawn loaded";
            }
        }
        return "environment";
    }

    static {
        ExprWorldCreatorOption.register(ExprWorldCreatorOption.class, Object.class, (String)"(0\u00a6environment|1\u00a6world type|2\u00a6world seed|3\u00a6gen[erator] settings|4\u00a6generator|5\u00a6should gen[erate] structures|6\u00a6[is] hardcore|7\u00a6keep spawn loaded)", (String)"worldcreator");
    }
}

