/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.objects;

import com.shanebeestudios.skbee.SkBee;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;

public class BeeWorldCreator {
    private final String worldName;
    private WorldType worldType;
    private World.Environment environment;
    private String generatorSettings;
    private String generator;
    Optional<Boolean> genStructures;
    Optional<Boolean> hardcore;
    Optional<Boolean> keepSpawnLoaded;
    long seed = -1L;
    private World world;
    private boolean clone;

    public BeeWorldCreator(String worldName) {
        this.worldName = worldName;
        this.genStructures = Optional.empty();
        this.hardcore = Optional.empty();
        this.keepSpawnLoaded = Optional.empty();
    }

    public BeeWorldCreator(World world, String name, boolean clone) {
        this.worldName = name;
        this.worldType = world.getWorldType();
        this.environment = world.getEnvironment();
        this.genStructures = Optional.of(world.canGenerateStructures());
        this.hardcore = Optional.of(world.isHardcore());
        this.keepSpawnLoaded = Optional.of(world.getKeepSpawnInMemory());
        this.seed = world.getSeed();
        this.world = world;
        this.clone = clone;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldType(WorldType worldType) {
        this.worldType = worldType;
    }

    public WorldType getWorldType() {
        return this.worldType;
    }

    public void setEnvironment(World.Environment environment) {
        this.environment = environment;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setGeneratorSettings(String generatorSettings) {
        this.generatorSettings = generatorSettings;
    }

    public String getGeneratorSettings() {
        return this.generatorSettings;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public void setGenStructures(boolean genStructures) {
        this.genStructures = Optional.of(genStructures);
    }

    public boolean isGenStructures() {
        return this.genStructures.orElse(true);
    }

    public boolean isHardcore() {
        return this.hardcore.orElse(false);
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = Optional.of(hardcore);
    }

    public boolean isKeepSpawnLoaded() {
        return this.keepSpawnLoaded.orElse(false);
    }

    public void setKeepSpawnLoaded(boolean loaded) {
        this.keepSpawnLoaded = Optional.of(loaded);
    }

    public World loadWorld() {
        WorldCreator worldCreator = this.world != null ? (this.clone ? this.cloneWorld() : this.copyWorld()) : new WorldCreator(this.worldName);
        if (worldCreator == null) {
            return null;
        }
        if (this.worldType != null) {
            worldCreator.type(this.worldType);
        }
        if (this.environment != null) {
            worldCreator.environment(this.environment);
        }
        if (this.seed > -1L) {
            worldCreator.seed(this.seed);
        }
        if (this.generatorSettings != null) {
            worldCreator.generatorSettings(this.generatorSettings);
        }
        if (this.generator != null) {
            worldCreator.generator(this.generator);
        }
        this.genStructures.ifPresent(arg_0 -> ((WorldCreator)worldCreator).generateStructures(arg_0));
        this.hardcore.ifPresent(arg_0 -> ((WorldCreator)worldCreator).hardcore(arg_0));
        World world = worldCreator.createWorld();
        if (world != null) {
            if (this.worldType == null) {
                this.worldType = world.getWorldType();
            }
            if (this.environment == null) {
                this.environment = world.getEnvironment();
            }
            if (this.seed == -1L) {
                this.seed = world.getSeed();
            }
            if (!this.genStructures.isPresent()) {
                this.genStructures = Optional.of(world.canGenerateStructures());
            }
            if (!this.hardcore.isPresent()) {
                this.hardcore = Optional.of(world.isHardcore());
            }
            this.keepSpawnLoaded.ifPresent(arg_0 -> ((World)world).setKeepSpawnInMemory(arg_0));
        }
        SkBee.getPlugin().getBeeWorldConfig().saveWorldToFile(this);
        return world;
    }

    private WorldCreator copyWorld() {
        WorldCreator worldCreator = new WorldCreator(this.worldName);
        worldCreator.copy(this.world);
        return worldCreator;
    }

    private WorldCreator cloneWorld() {
        File worldSaveLocation = Bukkit.getWorldContainer();
        File worldFile = this.world.getWorldFolder();
        File newWorldFile = new File(worldSaveLocation, this.worldName);
        if (worldFile.exists()) {
            try {
                FileUtils.copyDirectory(worldFile, newWorldFile);
                File uuidFile = new File(newWorldFile, "uid.dat");
                if (uuidFile.exists()) {
                    uuidFile.delete();
                }
                return new WorldCreator(this.worldName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorldCreator{");
        sb.append("worldName='").append(this.worldName).append('\'');
        sb.append(", worldType=").append(this.worldType);
        sb.append(", environment=").append(this.environment);
        sb.append(", generatorSettings='").append(this.generatorSettings).append('\'');
        sb.append(", generator='").append(this.generator).append('\'');
        sb.append(", genStructures=").append(this.genStructures);
        sb.append(", hardcore=").append(this.hardcore);
        sb.append(", keepSpawnLoaded=").append(this.keepSpawnLoaded);
        sb.append(", seed=").append(this.seed);
        sb.append(", world=").append(this.world);
        sb.append(", clone=").append(this.clone);
        sb.append('}');
        return sb.toString();
    }
}

