/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.nbt;

import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.nbt.NBT;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.nbt.NBTCustom;
import com.shanebeestudios.skbee.api.nbt.NBTEntity;
import com.shanebeestudios.skbee.api.nbt.NBTType;
import com.shanebeestudios.skbee.api.nbt.NbtApiException;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class NBTCustomEntity
extends NBTEntity
implements NBTCustom {
    private final Entity entity;

    public NBTCustomEntity(Entity entity) {
        super(entity);
        this.entity = entity;
        this.convert();
    }

    @Override
    public void deleteCustomNBT() {
        this.getPersistentDataContainer().removeKey("skbee-custom");
    }

    @Override
    @NotNull
    public NBTCompound getCustomNBT() {
        return this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
    }

    @Override
    public NBTCompound getOrCreateCompound(String name) {
        if (name.equals("data") && Util.IS_RUNNING_MC_1_21_5) {
            NBTContainer tempContainer = new NBTContainer(this.getCompound()){

                @Override
                protected void saveCompound() {
                    super.saveCompound();
                    NBTCompound data = this.getCompound("data");
                    if (data != null) {
                        NBT.modify(NBTCustomEntity.this.entity, readWriteNBT -> readWriteNBT.getOrCreateCompound("data").mergeCompound(data));
                    }
                }
            };
            return tempContainer.getOrCreateCompound(name);
        }
        if (name.equals("custom")) {
            return this.getCustomNBT();
        }
        try {
            return super.getOrCreateCompound(name);
        }
        catch (NbtApiException ignore) {
            return null;
        }
    }

    @Override
    public NBTCompound getCompound(String name) {
        if (name.equals("custom")) {
            return this.getCustomNBT();
        }
        return super.getCompound(name);
    }

    @Override
    public boolean hasTag(String key) {
        if (key.equalsIgnoreCase("custom")) {
            return true;
        }
        return super.hasTag(key);
    }

    @Override
    public void mergeCompound(NBTCompound comp) {
        super.mergeCompound(comp);
        if (comp.hasTag("custom")) {
            NBTCompound custom = comp.getCompound("custom");
            this.getCustomNBT().mergeCompound(custom);
        }
    }

    @Override
    public NBTType getType(String name) {
        if (name.equalsIgnoreCase("custom")) {
            return NBTType.NBTTagCompound;
        }
        return super.getType(name);
    }

    @Override
    public String toString() {
        return this.getCopy().toString();
    }

    @Override
    @NotNull
    public NBTCompound getCopy() {
        try {
            String bukkit = "BukkitValues";
            NBTContainer compound = new NBTContainer();
            compound.mergeCompound(this);
            NBTCompound custom = null;
            if (compound.hasTag(bukkit)) {
                NBTCompound persist = compound.getCompound(bukkit);
                assert (persist != null);
                persist.removeKey("__nbtapi");
                if (persist.hasTag("skbee-custom")) {
                    custom = this.getPersistentDataContainer().getCompound("skbee-custom");
                    persist.removeKey("skbee-custom");
                }
                if (persist.getKeys().isEmpty()) {
                    compound.removeKey(bukkit);
                }
            }
            NBTCompound customCompound = compound.getOrCreateCompound("custom");
            if (custom != null) {
                customCompound.mergeCompound(custom);
            }
            return compound;
        }
        catch (NbtApiException ex) {
            if (SkBee.isDebug()) {
                ex.printStackTrace();
            }
            return new NBTContainer();
        }
    }

    private void convert() {
        PersistentDataContainer container = this.entity.getPersistentDataContainer();
        if (container.has(OLD_KEY, PersistentDataType.STRING)) {
            String data = (String)container.get(OLD_KEY, PersistentDataType.STRING);
            NBTCompound custom = this.getOrCreateCompound("custom");
            if (data != null) {
                custom.mergeCompound(new NBTContainer(data));
            }
            container.remove(OLD_KEY);
        }
    }
}

