/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.nbt;

import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.nbt.NBTCustom;
import com.shanebeestudios.skbee.api.nbt.NBTFile;
import com.shanebeestudios.skbee.api.nbt.NBTType;
import com.shanebeestudios.skbee.api.nbt.NbtApiException;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class NBTCustomOfflinePlayer
extends NBTFile
implements NBTCustom {
    private static final String PLAYER_FOLDER;

    public NBTCustomOfflinePlayer(OfflinePlayer offlinePlayer) throws IOException {
        super(new File(PLAYER_FOLDER + String.valueOf(offlinePlayer.getUniqueId()) + ".dat"));
    }

    @Override
    public NBTCompound getOrCreateCompound(String name) {
        if (name.equals("custom")) {
            return this.getCustomNBT();
        }
        return super.getOrCreateCompound(name);
    }

    @Override
    public NBTCompound getCompound(String name) {
        if (name.equals("custom")) {
            return this.getCustomNBT();
        }
        return super.getCompound(name);
    }

    @Override
    public boolean hasTag(String key) {
        if (key.equalsIgnoreCase("custom")) {
            return true;
        }
        return super.hasTag(key);
    }

    @Override
    public void mergeCompound(NBTCompound comp) {
        super.mergeCompound(comp);
        if (comp.hasTag("custom")) {
            NBTCompound custom = comp.getCompound("custom");
            this.getCustomNBT().mergeCompound(custom);
        }
    }

    @Override
    public NBTType getType(String name) {
        if (name.equalsIgnoreCase("custom")) {
            return NBTType.NBTTagCompound;
        }
        return super.getType(name);
    }

    @Override
    protected void saveCompound() {
        try {
            super.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteCustomNBT() {
        if (this.hasTag("BukkitValues")) {
            this.getOrCreateCompound("BukkitValues").removeKey("skbee-custom");
        }
    }

    @Override
    @NotNull
    public NBTCompound getCustomNBT() {
        return super.getOrCreateCompound("BukkitValues").getOrCreateCompound("skbee-custom");
    }

    @Override
    public String toString() {
        return this.getCopy().toString();
    }

    @Override
    @NotNull
    public NBTCompound getCopy() {
        try {
            String bukkit = "BukkitValues";
            NBTContainer compound = new NBTContainer();
            compound.mergeCompound(this);
            NBTCompound custom = null;
            if (compound.hasTag(bukkit)) {
                NBTCompound persist = compound.getCompound(bukkit);
                assert (persist != null);
                persist.removeKey("__nbtapi");
                if (persist.hasTag("skbee-custom")) {
                    custom = this.getCustomNBT();
                    persist.removeKey("skbee-custom");
                }
                if (persist.getKeys().isEmpty()) {
                    compound.removeKey(bukkit);
                }
            }
            NBTCompound customCompound = compound.getOrCreateCompound("custom");
            if (custom != null) {
                customCompound.mergeCompound(custom);
            }
            return compound;
        }
        catch (NbtApiException ex) {
            if (SkBee.isDebug()) {
                ex.printStackTrace();
            }
            return new NBTContainer();
        }
    }

    static {
        String worldFolder = ((World)Bukkit.getWorlds().getFirst()).getWorldFolder().getPath();
        PLAYER_FOLDER = worldFolder + "/playerdata/";
    }
}

