/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.nbt;

import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.nbt.NBTCustom;
import com.shanebeestudios.skbee.api.nbt.NBTTileEntity;
import com.shanebeestudios.skbee.api.nbt.NBTType;
import com.shanebeestudios.skbee.api.nbt.NbtApiException;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class NBTCustomTileEntity
extends NBTTileEntity
implements NBTCustom {
    private final BlockState blockState;

    public NBTCustomTileEntity(BlockState tile) {
        super(tile);
        this.blockState = tile;
        this.convert();
    }

    @Override
    public void deleteCustomNBT() {
        this.getPersistentDataContainer().removeKey("skbee-custom");
    }

    @Override
    @NotNull
    public NBTCompound getCustomNBT() {
        return this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
    }

    @Override
    public NBTCompound getOrCreateCompound(String name) {
        if (name.equals("custom")) {
            return this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
        }
        try {
            return super.getOrCreateCompound(name);
        }
        catch (NbtApiException ignore) {
            return null;
        }
    }

    @Override
    public NBTCompound getCompound(String name) {
        if (name.equals("custom")) {
            return this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
        }
        return super.getCompound(name);
    }

    @Override
    public boolean hasTag(String key) {
        if (key.equalsIgnoreCase("custom")) {
            return true;
        }
        return super.hasTag(key);
    }

    @Override
    public void mergeCompound(NBTCompound comp) {
        super.mergeCompound(comp);
        if (comp.hasTag("custom")) {
            NBTCompound custom = comp.getOrCreateCompound("custom");
            NBTCompound customNBT = this.getPersistentDataContainer().getOrCreateCompound("skbee-custom");
            customNBT.mergeCompound(custom);
        }
    }

    @Override
    public NBTType getType(String name) {
        if (name.equalsIgnoreCase("custom")) {
            return NBTType.NBTTagCompound;
        }
        return super.getType(name);
    }

    @Override
    public String toString() {
        return this.getCopy().toString();
    }

    @Override
    @NotNull
    public NBTCompound getCopy() {
        try {
            String bukkit = "PublicBukkitValues";
            NBTContainer compound = new NBTContainer(new NBTTileEntity(this.blockState).toString());
            NBTCompound custom = null;
            if (compound.hasTag(bukkit)) {
                NBTCompound persist = compound.getCompound(bukkit);
                assert (persist != null);
                persist.removeKey("__nbtapi");
                if (persist.hasTag("skbee-custom")) {
                    custom = this.getPersistentDataContainer().getCompound("skbee-custom");
                    persist.removeKey("skbee-custom");
                }
                if (persist.getKeys().isEmpty()) {
                    compound.removeKey(bukkit);
                }
            }
            NBTCompound customCompound = compound.getOrCreateCompound("custom");
            if (custom != null) {
                customCompound.mergeCompound(custom);
            }
            compound.setInteger("x", this.blockState.getX());
            compound.setInteger("y", this.blockState.getY());
            compound.setInteger("z", this.blockState.getZ());
            return compound;
        }
        catch (NbtApiException ignore) {
            return new NBTContainer();
        }
    }

    private void convert() {
        PersistentDataContainer container = ((TileState)this.blockState).getPersistentDataContainer();
        if (container.has(OLD_KEY, PersistentDataType.STRING)) {
            String data = (String)container.get(OLD_KEY, PersistentDataType.STRING);
            container.remove(OLD_KEY);
            if (data != null) {
                this.blockState.update();
                NBTCompound custom = this.getOrCreateCompound("custom");
                custom.mergeCompound(new NBTContainer(data));
            }
        }
    }

    @Override
    protected void saveCompound() {
        super.saveCompound();
        this.blockState.getBlock().getState().update();
    }
}

