/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.reflection;

import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.reflection.ReflectionConstants;
import com.shanebeestudios.skbee.api.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.Nullable;

public class ChatReflection {
    private static final Class<?> ICHAT_BASE_COMPONENT_CLASS = ReflectionUtils.getNMSClass("net.minecraft.network.chat.Component", "IChatBaseComponent");
    private static final Class<?> CRAFT_CHAT_MESSAGE_CLASS = ReflectionUtils.getOBCClass("util.CraftChatMessage");
    private static final Class<?> TEXT_TAG_VISITOR_CLASS;
    private static final Class<?> NBT_BASE_CLASS;
    private static final Method FROM_COMPONENT;
    private static final Method VISIT_METHOD;
    private static final Class<?> CRAFT_CHAT_MESSAGE;
    private static final Class<?> CRAFT_TEAM;
    private static final Class<?> NMS_TEAM;
    private static final Method SET_PREFIX;
    private static final Method SET_SUFFIX;
    private static final Method PREFIX_COMP_METHOD;

    @Nullable
    public static String getPrettyNBT(NBTCompound compound, String split) {
        Object nmsNBT = new NBTContainer(compound.toString()).getCompound();
        String s = split != null ? split : "";
        try {
            Object tagVisitorInstance = TEXT_TAG_VISITOR_CLASS.getConstructor(String.class).newInstance(s);
            Object prettyComponent = VISIT_METHOD.invoke(tagVisitorInstance, nmsNBT);
            return (String)FROM_COMPONENT.invoke(CRAFT_CHAT_MESSAGE_CLASS, prettyComponent);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setTeamPrefix(Team team, String prefix) {
        if (CRAFT_TEAM == null || PREFIX_COMP_METHOD == null || SET_PREFIX == null) {
            team.setPrefix("");
            team.setSuffix("");
            return;
        }
        try {
            Object nmsTeam = ReflectionUtils.getField("team", CRAFT_TEAM, team);
            Object prefixComp = PREFIX_COMP_METHOD.invoke(null, prefix);
            SET_PREFIX.invoke(nmsTeam, prefixComp);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void setTeamSuffix(Team team, String suffix) {
        if (CRAFT_TEAM == null || PREFIX_COMP_METHOD == null || SET_SUFFIX == null) {
            team.setPrefix("");
            team.setSuffix("");
            return;
        }
        try {
            Object nmsTeam = ReflectionUtils.getField("team", CRAFT_TEAM, team);
            Object prefixComp = PREFIX_COMP_METHOD.invoke(null, suffix);
            SET_SUFFIX.invoke(nmsTeam, prefixComp);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        NBT_BASE_CLASS = ReflectionUtils.getNMSClass("net.minecraft.nbt.Tag", "NBTBase");
        TEXT_TAG_VISITOR_CLASS = ReflectionUtils.getNMSClass("net.minecraft.nbt.TextComponentTagVisitor");
        Method from_comp = null;
        Method visit = null;
        try {
            assert (TEXT_TAG_VISITOR_CLASS != null);
            assert (CRAFT_CHAT_MESSAGE_CLASS != null);
            visit = TEXT_TAG_VISITOR_CLASS.getDeclaredMethod(ReflectionConstants.TAG_VISITOR_VISIT_METHOD, NBT_BASE_CLASS);
            from_comp = CRAFT_CHAT_MESSAGE_CLASS.getMethod("fromComponent", ICHAT_BASE_COMPONENT_CLASS);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        FROM_COMPONENT = from_comp;
        VISIT_METHOD = visit;
        CRAFT_CHAT_MESSAGE = ReflectionUtils.getOBCClass("util.CraftChatMessage");
        CRAFT_TEAM = ReflectionUtils.getOBCClass("scoreboard.CraftTeam");
        NMS_TEAM = ReflectionUtils.getNMSClass("net.minecraft.world.scores.ScoreboardTeam");
        Method PREFIX_COMP_METHOD1 = null;
        Method SET_PREFIX1 = null;
        Method SET_SUFFIX1 = null;
        if (CRAFT_TEAM != null && NMS_TEAM != null && CRAFT_CHAT_MESSAGE != null) {
            try {
                SET_PREFIX1 = NMS_TEAM.getDeclaredMethod(ReflectionConstants.NMS_SCOREBOARD_TEAM_SET_PREFIX_METHOD, ICHAT_BASE_COMPONENT_CLASS);
                SET_SUFFIX1 = NMS_TEAM.getDeclaredMethod(ReflectionConstants.NMS_SCOREBOARD_TEAM_SET_SUFFIX_METHOD, ICHAT_BASE_COMPONENT_CLASS);
                PREFIX_COMP_METHOD1 = CRAFT_CHAT_MESSAGE.getDeclaredMethod("fromStringOrNull", String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        PREFIX_COMP_METHOD = PREFIX_COMP_METHOD1;
        SET_PREFIX = SET_PREFIX1;
        SET_SUFFIX = SET_SUFFIX1;
    }
}

