/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.region;

import com.shanebeestudios.skbee.api.region.scheduler.FoliaScheduler;
import com.shanebeestudios.skbee.api.region.scheduler.Scheduler;
import com.shanebeestudios.skbee.api.region.scheduler.SpigotScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class TaskUtils {
    private static Plugin plugin;
    private static boolean useFoliaSchedulers;

    public static void initialize(@NotNull Plugin plugin, boolean useFoliaSchedulers) {
        if (TaskUtils.plugin != null) {
            throw new IllegalStateException("TaskUtils already initialized!");
        }
        TaskUtils.plugin = plugin;
        TaskUtils.useFoliaSchedulers = useFoliaSchedulers;
    }

    public static Plugin getPlugin() {
        TaskUtils.pluginCheck();
        return plugin;
    }

    public static Scheduler<?> getGlobalScheduler() {
        TaskUtils.pluginCheck();
        if (useFoliaSchedulers) {
            return FoliaScheduler.getGlobalScheduler();
        }
        return new SpigotScheduler();
    }

    public static Scheduler<?> getRegionalScheduler(Location location) {
        TaskUtils.pluginCheck();
        if (useFoliaSchedulers) {
            return FoliaScheduler.getRegionalScheduler(location);
        }
        return new SpigotScheduler();
    }

    public static Scheduler<?> getEntityScheduler(Entity entity) {
        TaskUtils.pluginCheck();
        if (useFoliaSchedulers) {
            return FoliaScheduler.getEntityScheduler(entity);
        }
        return new SpigotScheduler();
    }

    public static void cancelTasks() {
        TaskUtils.pluginCheck();
        if (useFoliaSchedulers) {
            Bukkit.getGlobalRegionScheduler().cancelTasks(plugin);
            Bukkit.getAsyncScheduler().cancelTasks(plugin);
        } else {
            Bukkit.getScheduler().cancelTasks(plugin);
        }
    }

    private static void pluginCheck() {
        if (plugin == null) {
            throw new IllegalStateException("TaskUtils has not been initialized!");
        }
    }
}

