/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.scoreboard;

import com.google.gson.JsonParseException;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import io.papermc.paper.scoreboard.numbers.FixedFormat;
import io.papermc.paper.scoreboard.numbers.NumberFormat;
import io.papermc.paper.scoreboard.numbers.StyledFormat;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import org.jetbrains.annotations.Nullable;

public class NumberFormatUtils {
    public static NumberFormat getNumberFormatStyled(Style style) {
        return NumberFormat.styled((Style)style);
    }

    public static NumberFormat getNumberFormatBlank() {
        return NumberFormat.blank();
    }

    public static NumberFormat getNumberFormatFixed(String score) {
        ComponentWrapper comp = ComponentWrapper.fromText(score);
        return NumberFormat.fixed((ComponentLike)comp.getComponent());
    }

    public static NumberFormat getNumberFormatFixed(ComponentWrapper score) {
        return NumberFormat.fixed((ComponentLike)score.getComponent());
    }

    @Nullable
    public static NumberFormat getJsonFormat(String score) {
        try {
            Component deserialize = JSONComponentSerializer.json().deserialize((Object)score);
            return NumberFormat.styled((Style)deserialize.style());
        }
        catch (JsonParseException ig) {
            return null;
        }
    }

    public static String getStringifiedNumberFormat(NumberFormat numberFormat) {
        if (numberFormat instanceof FixedFormat) {
            FixedFormat fixedFormat = (FixedFormat)numberFormat;
            return ComponentWrapper.fromComponent(fixedFormat.component()).toString();
        }
        if (numberFormat instanceof StyledFormat) {
            StyledFormat styledFormat = (StyledFormat)numberFormat;
            Style style = styledFormat.style();
            TextComponent component = Component.text((String)"", (Style)style);
            String s = (String)JSONComponentSerializer.json().serialize((Component)component);
            return s.replace(",\"text\":\"\"", "");
        }
        return "blank";
    }
}

