/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.scoreboard;

import ch.njol.skript.Skript;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class TeamUtils {
    private static final boolean ENTITY_TEAM = Skript.methodExists(Scoreboard.class, (String)"getEntityTeam", (Class[])new Class[]{Entity.class});
    private static final Pattern UUID_PATTERN = Pattern.compile("(?i)[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}");

    public static boolean isRegistered(String name, Scoreboard scoreboard) {
        return scoreboard.getTeam(name) != null;
    }

    public static Team getTeam(String name, Scoreboard scoreboard) {
        Team team = scoreboard.getTeam(name);
        if (team == null) {
            team = scoreboard.registerNewTeam(name);
        }
        return team;
    }

    public static Team getTeam(Entity entity, Scoreboard scoreboard) {
        if (ENTITY_TEAM) {
            return scoreboard.getEntityTeam(entity);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return scoreboard.getEntryTeam(player.getName());
        }
        return scoreboard.getEntryTeam(entity.getUniqueId().toString());
    }

    public static List<Team> getTeams(Scoreboard scoreboard) {
        return new ArrayList<Team>(scoreboard.getTeams());
    }

    public static List<Entity> getEntries(Team team) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        team.getEntries().forEach(entry -> {
            if (UUID_PATTERN.matcher((CharSequence)entry).matches()) {
                Entity ent = Bukkit.getServer().getEntity(UUID.fromString(entry));
                if (ent != null) {
                    entities.add(ent);
                }
            } else {
                Player player = Bukkit.getPlayer((String)entry);
                if (player != null) {
                    entities.add((Entity)player);
                }
            }
        });
        return entities;
    }
}

