/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.command.EffectCommandEvent;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import com.shanebeestudios.skbee.api.reflection.ReflectionUtils;
import com.shanebeestudios.skbee.api.util.Util;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.ApiStatus;

public class SkriptUtils {
    private static Field LAST_SPAWNED;

    public static void setLastSpawned(Entity entity) {
        if (LAST_SPAWNED != null) {
            try {
                LAST_SPAWNED.set(null, entity);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static int[] getElementCount() {
        int[] i = new int[5];
        i[0] = Skript.getEvents().size();
        i[1] = Skript.getEffects().size();
        AtomicInteger exprs = new AtomicInteger();
        Skript.getExpressions().forEachRemaining(e -> exprs.getAndIncrement());
        i[2] = exprs.get();
        i[3] = Skript.getConditions().size();
        i[4] = Skript.getSections().size();
        return i;
    }

    public static boolean parseEffect(String stringEffect, CommandSender sender) {
        ParserInstance parserInstance = ParserInstance.get();
        parserInstance.setCurrentEvent("effect command", new Class[]{EffectCommandEvent.class});
        Effect effect = Effect.parse((String)stringEffect, null);
        parserInstance.deleteCurrentEvent();
        if (effect != null) {
            return TriggerItem.walk((TriggerItem)effect, (Event)new EffectCommandEvent(sender, stringEffect));
        }
        return false;
    }

    public static <T> Parser<T> getDefaultParser() {
        return new Parser<T>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(T o, int flags) {
                return o.toString();
            }

            public String toVariableNameString(T o) {
                return o.toString();
            }
        };
    }

    public static Map<String, EquipmentSlotGroup> getEquipmentSlotGroups() {
        HashMap<String, EquipmentSlotGroup> groups = new HashMap<String, EquipmentSlotGroup>();
        for (Field declaredField : EquipmentSlotGroup.class.getDeclaredFields()) {
            if (!EquipmentSlotGroup.class.isAssignableFrom(declaredField.getType())) continue;
            try {
                EquipmentSlotGroup equipmentSlotGroup = (EquipmentSlotGroup)declaredField.get(null);
                String name = declaredField.getName().toLowerCase(Locale.ROOT) + "_slot_group";
                groups.put(name, equipmentSlotGroup);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return groups;
    }

    public static Expression<?> parseExpression(String expr) {
        Expression mappingExpr = new SkriptParser(expr, 3, ParseContext.DEFAULT).parseExpression(new Class[]{Object.class});
        if (LiteralUtils.hasUnparsedLiteral((Expression)mappingExpr)) {
            mappingExpr = LiteralUtils.defendExpression((Expression)mappingExpr);
            if (!LiteralUtils.canInitSafely((Expression[])new Expression[]{mappingExpr})) {
                return null;
            }
        }
        return mappingExpr;
    }

    @ApiStatus.Internal
    public static void hackPotionEffectTypeClassInfoPattern() {
        if (Util.IS_RUNNING_SKRIPT_2_11) {
            return;
        }
        ClassInfo info = Classes.getExactClassInfo(PotionEffectType.class);
        assert (info != null);
        Pattern[] patterns = new Pattern[]{Pattern.compile("potion ?effect ?types?")};
        ReflectionUtils.setField("userInputPatterns", ClassInfo.class, info, patterns);
    }

    static {
        try {
            Class<?> effSpawnClass = Skript.classExists((String)"ch.njol.skript.sections.EffSecSpawn") ? Class.forName("ch.njol.skript.sections.EffSecSpawn") : Class.forName("ch.njol.skript.effects.EffSpawn");
            LAST_SPAWNED = effSpawnClass.getDeclaredField("lastSpawned");
        }
        catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }
}

