/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace;

import com.shanebeestudios.skbee.api.virtualfurnace.api.FurnaceManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.RecipeManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.TileManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.api.virtualfurnace.api.recipe.Fuel;
import com.shanebeestudios.skbee.api.virtualfurnace.api.recipe.FurnaceRecipe;
import com.shanebeestudios.skbee.api.virtualfurnace.api.util.Util;
import com.shanebeestudios.skbee.api.virtualfurnace.command.FurnaceCommand;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VirtualFurnace
extends JavaPlugin {
    private boolean enabled = true;
    private static VirtualFurnace instance;
    private VirtualFurnaceAPI virtualFurnaceAPI;
    private RecipeManager recipeManager;
    private FurnaceManager furnaceManager;
    private TileManager tileManager;

    public void onEnable() {
        instance = this;
        long start = System.currentTimeMillis();
        Util.log("&7Setting up &bVirtualFurnaceAPI");
        this.virtualFurnaceAPI = new VirtualFurnaceAPI(this);
        if (!this.virtualFurnaceAPI.isEnabled()) {
            Util.log("Failed to load!");
            this.enabled = false;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.recipeManager = this.virtualFurnaceAPI.getRecipeManager();
        this.furnaceManager = this.virtualFurnaceAPI.getFurnaceManager();
        this.tileManager = this.virtualFurnaceAPI.getTileManager();
        this.registerCommands();
        this.registerRecipes();
        this.registerFuels();
        Util.log("&7Setup &asuccessful&7 in &b" + (System.currentTimeMillis() - start) + " &7milliseconds");
    }

    public void onDisable() {
        instance = null;
        this.tileManager = null;
        this.furnaceManager = null;
        this.recipeManager = null;
        this.virtualFurnaceAPI.disableAPI();
        this.virtualFurnaceAPI = null;
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("furnace").setExecutor((CommandExecutor)new FurnaceCommand(this));
    }

    private void registerRecipes() {
        for (FurnaceRecipe recipe : FurnaceRecipe.getVanillaFurnaceRecipes()) {
            this.recipeManager.registerFurnaceRecipe(recipe);
        }
    }

    private void registerFuels() {
        for (Fuel fuel : Fuel.getVanillaFuels()) {
            this.recipeManager.registerFuel(fuel);
        }
        Fuel goldF = new Fuel(Util.getKey("gold_fuel"), Material.GOLD_INGOT, 800);
        this.recipeManager.registerFuel(goldF);
    }

    public static VirtualFurnace getPlugin() {
        return instance;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public FurnaceManager getFurnaceManager() {
        return this.furnaceManager;
    }

    public VirtualFurnaceAPI getVirtualFurnaceAPI() {
        return this.virtualFurnaceAPI;
    }
}

