/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api.tile;

import com.shanebeestudios.skbee.api.virtualfurnace.api.VirtualFurnaceAPI;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Furnace;
import com.shanebeestudios.skbee.api.virtualfurnace.api.tile.Tile;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class FurnaceTile
extends Tile<Furnace>
implements ConfigurationSerializable {
    public FurnaceTile(@NotNull Furnace machine, @NotNull Block block) {
        super(machine, block);
    }

    public FurnaceTile(@NotNull Furnace machine, int x, int y, int z, @NotNull World world) {
        super(machine, x, y, z, world);
    }

    private FurnaceTile(@NotNull Furnace machine, int x, int y, int z, @NotNull String world) {
        super(machine, x, y, z, world);
    }

    @Override
    public void breakTile() {
        BukkitRunnable runnable = new BukkitRunnable(){
            final ItemStack fuel;
            final ItemStack input;
            final ItemStack output;
            final float xp;
            final Vector vec;
            {
                this.fuel = ((Furnace)FurnaceTile.this.machine).getFuel();
                this.input = ((Furnace)FurnaceTile.this.machine).getInput();
                this.output = ((Furnace)FurnaceTile.this.machine).getOutput();
                this.xp = ((Furnace)FurnaceTile.this.machine).extractExperience();
                this.vec = new Vector(0, 0, 0);
            }

            public void run() {
                World world = FurnaceTile.this.getBukkitWorld();
                Location drop = new Location(world, (double)FurnaceTile.this.x + 0.5, (double)FurnaceTile.this.y + 0.5, (double)FurnaceTile.this.z + 0.5);
                if (this.fuel != null) {
                    world.dropItem(drop, this.fuel).setVelocity(this.vec);
                }
                if (this.input != null) {
                    world.dropItem(drop, this.input).setVelocity(this.vec);
                }
                if (this.output != null) {
                    world.dropItem(drop, this.output).setVelocity(this.vec);
                }
                if (this.xp > 0.0f) {
                    ((ExperienceOrb)world.spawn(drop, ExperienceOrb.class, orb -> orb.setExperience((int)this.xp))).setVelocity(this.vec);
                }
            }
        };
        runnable.runTaskLater((Plugin)VirtualFurnaceAPI.getInstance().getJavaPlugin(), 0L);
        super.breakTile();
    }

    @Override
    public String getString() {
        return "FurnaceTile{machine-type=" + ((Furnace)this.machine).getClass().getSimpleName() + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", world='" + this.world + "'}";
    }

    @Override
    public String toString() {
        return "FurnaceTile{machine=" + String.valueOf(this.machine) + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", world='" + this.world + "'} ";
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("machine", this.machine);
        result.put("x", this.x);
        result.put("y", this.y);
        result.put("z", this.z);
        result.put("world", this.world);
        return result;
    }

    public static FurnaceTile deserialize(Map<String, Object> args) {
        int x = (Integer)args.get("x");
        int y = (Integer)args.get("y");
        int z = (Integer)args.get("z");
        String world = (String)args.get("world");
        return new FurnaceTile((Furnace)args.get("machine"), x, y, z, world);
    }
}

