/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.wrapper;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ColorRGB;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.slot.Slot;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.ChatUtil;
import com.shanebeestudios.skbee.api.util.TextCompUtil;
import com.shanebeestudios.skbee.api.util.Util;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentWrapper {
    private static final boolean HAS_SIDES = Skript.classExists((String)"org.bukkit.block.sign.SignSide");
    public static final boolean HAS_ITEM_NAME = Skript.methodExists(ItemMeta.class, (String)"itemName", (Class[])new Class[0]);
    private Component component;

    public static ComponentWrapper empty() {
        return new ComponentWrapper((Component)Component.empty());
    }

    public static ComponentWrapper fromText(String text) {
        TextComponent component = text.contains("\u00a7") ? LegacyComponentSerializer.legacySection().deserialize(text) : (text.contains("&") ? LegacyComponentSerializer.legacyAmpersand().deserialize(text) : Component.text((String)text));
        return new ComponentWrapper((Component)component);
    }

    public static ComponentWrapper fromRawText(String text) {
        return new ComponentWrapper((Component)Component.text((String)text));
    }

    public static ComponentWrapper fromMiniMessage(@NotNull String text, TagResolver ... resolvers) {
        TextComponent deserialize;
        String string = text.replaceAll("##(\\w{6})", "#$1");
        if (text.contains("&")) {
            deserialize = LegacyComponentSerializer.legacyAmpersand().deserialize(string);
            string = PlainTextComponentSerializer.plainText().serialize((Component)deserialize);
        }
        if (text.contains("\u00a7")) {
            deserialize = LegacyComponentSerializer.legacySection().deserialize(string);
            string = PlainTextComponentSerializer.plainText().serialize((Component)deserialize);
        }
        if (resolvers == null) {
            return new ComponentWrapper(MiniMessage.miniMessage().deserialize((Object)string));
        }
        return new ComponentWrapper(MiniMessage.miniMessage().deserialize(string, resolvers));
    }

    public static ComponentWrapper fromKeybind(String keybind) {
        return new ComponentWrapper((Component)Component.keybind((String)keybind));
    }

    public static ComponentWrapper fromTranslate(String translate) {
        return new ComponentWrapper((Component)Component.translatable((String)translate));
    }

    public static ComponentWrapper fromTranslate(String translate, @Nullable String fallback, Object ... objects) {
        ArrayList<Object> comps = new ArrayList<Object>();
        for (Object object : objects) {
            if (object instanceof ComponentWrapper) {
                ComponentWrapper component = (ComponentWrapper)object;
                comps.add(component.component);
                continue;
            }
            if (object instanceof String) {
                String string = (String)object;
                comps.add(Component.text((String)string));
                continue;
            }
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                comps.add(entity.name());
                continue;
            }
            if (object instanceof ItemType || object instanceof ItemStack || object instanceof Slot) {
                comps.add(ComponentWrapper.getItem(object));
                continue;
            }
            if (object instanceof Translatable) {
                Translatable translatable = (Translatable)object;
                comps.add(Component.translatable((Translatable)translatable));
                continue;
            }
            String objectString = Classes.toString((Object)object);
            comps.add(Component.text((String)objectString));
        }
        return new ComponentWrapper((Component)Component.translatable((String)translate, (String)fallback, comps, (StyleBuilderApplicable[])new StyleBuilderApplicable[0]));
    }

    public static ComponentWrapper fromJson(String json) {
        Component deserialize = JSONComponentSerializer.json().deserialize((Object)json);
        return new ComponentWrapper(deserialize);
    }

    @Nullable
    private static Component getItem(Object object) {
        ItemStack itemStack = null;
        Material material = null;
        if (object instanceof ItemStack) {
            ItemStack is;
            itemStack = is = (ItemStack)object;
        } else if (object instanceof ItemType) {
            ItemType itemType = (ItemType)object;
            itemStack = itemType.getRandom();
            if (itemStack != null) {
                material = itemStack.getType();
            }
        } else if (object instanceof Slot) {
            Slot slot = (Slot)object;
            itemStack = slot.getItem();
        }
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta.hasDisplayName()) {
            return itemMeta.displayName();
        }
        if (material == null) {
            material = itemStack.getType();
        }
        return Component.translatable((Translatable)material);
    }

    public static ComponentWrapper fromComponent(Component component) {
        return new ComponentWrapper(component);
    }

    public static ComponentWrapper fromComponents(ComponentWrapper ... components) {
        return ComponentWrapper.fromComponents(components, null);
    }

    public static ComponentWrapper fromComponents(@Nullable ComponentWrapper[] components, @Nullable ComponentWrapper delimiter) {
        TextComponent component = Component.empty();
        if (components != null && components.length > 0) {
            Component delimiterComp;
            Component component2 = delimiterComp = delimiter != null ? delimiter.component : null;
            assert (components[0] != null);
            component = component.append(components[0].component);
            int end = components.length;
            for (int i = 1; i < end; ++i) {
                if (components[i] == null) continue;
                if (delimiterComp != null) {
                    component = component.append(delimiterComp);
                }
                component = component.append(components[i].component);
            }
        }
        return new ComponentWrapper((Component)component);
    }

    public ComponentWrapper(Component component) {
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public List<ComponentWrapper> getChildren() {
        ArrayList<ComponentWrapper> children = new ArrayList<ComponentWrapper>();
        this.component.children().forEach(child -> children.add(ComponentWrapper.fromComponent(child)));
        return children;
    }

    public void append(ComponentWrapper componentWrapper) {
        this.component = this.component.append(componentWrapper.component);
    }

    public void setHoverEvent(HoverEvent<?> hoverEvent) {
        this.component = this.component.hoverEvent(hoverEvent);
    }

    public HoverEvent<?> getHoverEvent() {
        return this.component.hoverEvent();
    }

    public void setClickEvent(ClickEvent clickEvent) {
        this.component = this.component.clickEvent(clickEvent);
    }

    public ClickEvent getClickEvent() {
        return this.component.clickEvent();
    }

    public void setColor(Color color) {
        this.component = this.component.color(ChatUtil.getTextColorFromColor(color));
    }

    @Nullable
    public Color getColor() {
        TextColor textColor = this.component.color();
        if (textColor == null) {
            return null;
        }
        SkriptColor skriptColor = ChatUtil.getSkriptColorFromTextColor(textColor);
        if (skriptColor != null) {
            return skriptColor;
        }
        return ColorRGB.fromRGB((int)textColor.red(), (int)textColor.green(), (int)textColor.blue());
    }

    public void setShadowColor(Color color) {
        if (!Util.IS_RUNNING_MC_1_21_4) {
            return;
        }
        TextCompUtil.setShadowColor(this, color);
    }

    public Color getShadowColor() {
        if (!Util.IS_RUNNING_MC_1_21_4) {
            return null;
        }
        return TextCompUtil.getShadowColor(this);
    }

    public void setBold(boolean bold) {
        this.component = this.component.decoration(TextDecoration.BOLD, bold);
    }

    public boolean isBold() {
        return this.component.decoration(TextDecoration.BOLD).toString().equals("true");
    }

    public void setItalic(boolean italic) {
        this.component = this.component.decoration(TextDecoration.ITALIC, italic);
    }

    public boolean isItalic() {
        return this.component.decoration(TextDecoration.ITALIC).toString().equals("true");
    }

    public void setObfuscated(boolean obfuscated) {
        this.component = this.component.decoration(TextDecoration.OBFUSCATED, obfuscated);
    }

    public boolean isObfuscated() {
        return this.component.decoration(TextDecoration.OBFUSCATED).toString().equals("true");
    }

    public void setStrikethrough(boolean strikethrough) {
        this.component = this.component.decoration(TextDecoration.STRIKETHROUGH, strikethrough);
    }

    public boolean isStrikethrough() {
        return this.component.decoration(TextDecoration.STRIKETHROUGH).toString().equals("true");
    }

    public void setUnderlined(boolean underlined) {
        this.component = this.component.decoration(TextDecoration.UNDERLINED, underlined);
    }

    public boolean isUnderlined() {
        return this.component.decoration(TextDecoration.UNDERLINED).toString().equals("true");
    }

    public void setFont(String font) {
        this.component = this.component.font(Key.key((String)font));
    }

    @Nullable
    public String getFont() {
        Key font = this.component.font();
        if (font != null) {
            return font.asString();
        }
        return null;
    }

    public void setFallback(String fallback) {
        Component component = this.component;
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            this.component = translatable.fallback(fallback);
        }
    }

    public String getFallback() {
        Component component = this.component;
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            return translatable.fallback();
        }
        return null;
    }

    public void setInsertion(String insertion) {
        this.component = this.component.insertion(insertion);
    }

    public String getInsertion() {
        return this.component.insertion();
    }

    public void replace(boolean regex, boolean replaceFirst, Object replacement, String ... patterns) {
        TextReplacementConfig.Builder replacementConfig = TextReplacementConfig.builder();
        if (replacement instanceof String) {
            String string = (String)replacement;
            replacementConfig.replacement(string);
        } else if (replacement instanceof ComponentWrapper) {
            ComponentWrapper componentWrapper = (ComponentWrapper)replacement;
            replacementConfig.replacement((ComponentLike)componentWrapper.getComponent());
        } else {
            replacementConfig.replacement(Classes.toString((Object)replacement));
        }
        if (replaceFirst) {
            replacementConfig.once();
        }
        for (String pattern : patterns) {
            if (regex) {
                try {
                    replacementConfig.match(pattern);
                }
                catch (PatternSyntaxException exception) {
                    if (SkBee.isDebug()) {
                        exception.printStackTrace();
                    }
                }
            } else {
                replacementConfig.matchLiteral(pattern);
            }
            this.component = this.component.replaceText((TextReplacementConfig)replacementConfig.build());
        }
    }

    public void sendMessage(Audience audience) {
        audience.sendMessage(this.component);
    }

    public void sendActionBar(Audience audience) {
        audience.sendActionBar(this.component);
    }

    public void broadcast() {
        this.sendMessage((Audience)Bukkit.getServer());
    }

    public void setBlockLine(Block block, int line, boolean front) {
        BlockState blockState = block.getState();
        if (blockState instanceof Sign) {
            Sign sign = (Sign)blockState;
            if (!front && HAS_SIDES) {
                sign.getSide(Side.BACK).line(line, this.component);
            } else {
                sign.line(line, this.component);
            }
            sign.update();
        }
    }

    @Nullable
    public static ComponentWrapper getSignLine(Block block, int line, boolean front) {
        BlockState blockState = block.getState();
        if (blockState instanceof Sign) {
            Sign sign = (Sign)blockState;
            Component lineComponent = !front && HAS_SIDES ? sign.getSide(Side.BACK).line(line) : sign.line(line);
            if (!lineComponent.equals((Object)Component.empty())) {
                return ComponentWrapper.fromComponent(lineComponent);
            }
        }
        return null;
    }

    public void setEntityName(Entity entity, boolean display) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.displayName(this.component);
        } else {
            entity.customName(this.component);
            entity.setCustomNameVisible(display);
        }
    }

    public void setInventoryName(Inventory inventory) {
        List viewers = inventory.getViewers();
        if (viewers.isEmpty()) {
            return;
        }
        viewers.forEach(player -> {
            InventoryView view = player.getOpenInventory();
            if (view.getTopInventory().getType().isCreatable()) {
                view.setTitle(this.toString());
            }
        });
    }

    public void setTeamPrefix(Team team) {
        team.prefix(this.getComponent());
    }

    public void setTeamSuffix(Team team) {
        team.suffix(this.getComponent());
    }

    public static void sendTitle(Audience[] audiences, @NotNull Object title, @Nullable Object subtitle, long stay, long fadeIn, long fadeOut) {
        Component subtitleComponent;
        String string;
        Component titleComponent;
        ComponentWrapper componentWrapper;
        if (title instanceof ComponentWrapper) {
            componentWrapper = (ComponentWrapper)title;
            titleComponent = componentWrapper.getComponent();
        } else if (title instanceof String) {
            string = (String)title;
            titleComponent = Component.text((String)string);
        } else {
            titleComponent = Component.text((String)"");
        }
        if (subtitle instanceof ComponentWrapper) {
            componentWrapper = (ComponentWrapper)subtitle;
            subtitleComponent = componentWrapper.getComponent();
        } else if (subtitle instanceof String) {
            string = (String)subtitle;
            subtitleComponent = Component.text((String)string);
        } else {
            subtitleComponent = Component.text((String)"");
        }
        Title.Times times = Title.Times.times((Duration)Duration.ofMillis(fadeIn * 50L), (Duration)Duration.ofMillis(stay * 50L), (Duration)Duration.ofMillis(fadeOut * 50L));
        Title titleTitle = Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)times);
        for (Audience audience : audiences) {
            audience.showTitle(titleTitle);
        }
    }

    public static void sendSignChange(Player player, Location location, ComponentWrapper[] componentWrappers, @Nullable DyeColor color, boolean isGlowing) {
        ArrayList<Object> components = new ArrayList<Object>();
        for (int i = 0; i < 4; ++i) {
            if (componentWrappers.length > i) {
                components.add(componentWrappers[i].component);
                continue;
            }
            components.add(Component.text((String)""));
        }
        if (color == null) {
            player.sendSignChange(location, components, isGlowing);
        } else {
            player.sendSignChange(location, components, color, isGlowing);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentWrapper)) {
            return false;
        }
        ComponentWrapper cw = (ComponentWrapper)obj;
        return cw.toString().equals(this.toString());
    }

    public String toString() {
        if (this.component == null) {
            return "";
        }
        return LegacyComponentSerializer.legacySection().serialize(this.component);
    }

    public String toJsonString() {
        if (this.component == null) {
            return "{}";
        }
        return (String)JSONComponentSerializer.json().serialize(this.component);
    }
}

