/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.advancement.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Advancement - Progress Criteria")
@Description(value={"Get the awarded/remaining criteria of an advancement progress."})
@Examples(value={"set {_c::*} to awarded criteria of advancement progress of {_advancement} of player"})
@Since(value={"1.17.0"})
public class ExprAdvancementProgressAwarded
extends SimpleExpression<String> {
    private boolean awarded;
    private Expression<AdvancementProgress> progress;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.awarded = parseResult.mark == 0;
        this.progress = exprs[0];
        return true;
    }

    @Nullable
    protected String[] get(Event event) {
        AdvancementProgress progress = (AdvancementProgress)this.progress.getSingle(event);
        if (progress == null) {
            return null;
        }
        if (this.awarded) {
            return progress.getAwardedCriteria().toArray(new String[0]);
        }
        return progress.getRemainingCriteria().toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String award = this.awarded ? "awarded" : "remaining";
        return award + " criteria of " + this.progress.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprAdvancementProgressAwarded.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(awarded|1:remaining) criteria of %advancementpro%"});
    }
}

