/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bossbar.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BossBar - From ID")
@Description(value={"Get an already created BossBar from ID (this will NOT create a new one)."})
@Examples(value={"delete boss bar with id \"le-bar\"", "set {_bar} to boss bar with id \"le-bar\"", "add all players to {_bar}"})
@Since(value={"2.14.1"})
public class ExprBossBarByID
extends SimpleExpression<BossBar> {
    private Expression<String> key;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.key = exprs[0];
        return true;
    }

    protected BossBar @Nullable [] get(Event event) {
        KeyedBossBar bossBar;
        String name = (String)this.key.getSingle(event);
        if (name == null) {
            return null;
        }
        NamespacedKey key = Util.getNamespacedKey(name, true);
        if (key != null && (bossBar = Bukkit.getBossBar((NamespacedKey)key)) != null) {
            return new BossBar[]{bossBar};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends BossBar> getReturnType() {
        return BossBar.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "bossbar with id " + this.key.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBossBarByID.class, BossBar.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"boss[ ]bar (named|with id|from id) %string%"});
    }
}

