/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bossbar.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.BossBarUtils;
import com.shanebeestudios.skbee.api.util.MathUtil;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BossBar - Properties")
@Description(value={"Represents the properties of a BossBar that can be changed.", "Progress of a bar is a number from 0-100."})
@Examples(value={"set {_players::*} to bar players of {_bar}", "set bar color of {_bar} to blue", "set bar style of {_bar} to segmented 20", "set bar title of {_bar} to \"Le-Title\"", "reset bar title of {_bar}", "set bar progress of {_bar} to 100", "set bar flag darken sky of {_bar} to true"})
@Since(value={"2.14.1"})
public class ExprBossBarProperties
extends SimpleExpression<Object> {
    private static final int PLAYERS = 0;
    private static final int BAR_COLOR = 1;
    private static final int BAR_STYLE = 2;
    private static final int BAR_TITLE = 3;
    private static final int BAR_PROGRESS = 4;
    private static final int BAR_FLAG = 5;
    private static final int BAR_VISIBILITY = 6;
    private int pattern;
    private Expression<BossBar> bossBar;
    private Expression<BarFlag> barFlag;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.bossBar = exprs[this.pattern == 5 ? 1 : 0];
        this.barFlag = this.pattern == 5 ? exprs[0] : null;
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        BossBar bossBar = (BossBar)this.bossBar.getSingle(event);
        if (bossBar == null) {
            return null;
        }
        switch (this.pattern) {
            case 0: {
                return bossBar.getPlayers().toArray(new Player[0]);
            }
            case 1: {
                return new SkriptColor[]{BossBarUtils.getSkriptColor(bossBar.getColor())};
            }
            case 2: {
                return new BarStyle[]{bossBar.getStyle()};
            }
            case 3: {
                return new String[]{bossBar.getTitle()};
            }
            case 4: {
                return new Number[]{bossBar.getProgress() * 100.0};
            }
            case 5: {
                BarFlag barFlag = (BarFlag)this.barFlag.getSingle(event);
                if (barFlag == null) {
                    return null;
                }
                return new Boolean[]{bossBar.hasFlag(barFlag)};
            }
            case 6: {
                return new Boolean[]{bossBar.isVisible()};
            }
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (this.pattern == 0) {
            if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Player[].class});
            }
        } else {
            if (this.pattern == 1 && mode == Changer.ChangeMode.SET) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Color.class, BarColor.class});
            }
            if (this.pattern == 2 && mode == Changer.ChangeMode.SET) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{BarStyle.class});
            }
            if (this.pattern == 3 && (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE)) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
            }
            if (this.pattern == 4) {
                if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
                }
            } else if (this.pattern == 5 ? mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE : this.pattern == 6 && mode == Changer.ChangeMode.SET) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
            }
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object = delta != null ? delta[0] : null;
        BossBar bossBar = (BossBar)this.bossBar.getSingle(event);
        if (bossBar == null) {
            return;
        }
        if (this.pattern == 0) {
            if (delta instanceof Player[]) {
                Player[] players = (Player[])delta;
                if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
                    bossBar.removeAll();
                }
                if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET) {
                    for (Player player : players) {
                        bossBar.addPlayer(player);
                    }
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    for (Player player : players) {
                        bossBar.removePlayer(player);
                    }
                }
            }
        } else if (this.pattern == 1 && mode == Changer.ChangeMode.SET) {
            if (object instanceof SkriptColor) {
                SkriptColor skriptColor = (SkriptColor)object;
                BarColor bossBarColor = BossBarUtils.getBossBarColor(skriptColor);
                bossBar.setColor(bossBarColor);
            } else if (object instanceof BarColor) {
                BarColor barColor = (BarColor)object;
                bossBar.setColor(barColor);
            }
        } else if (this.pattern == 2 && mode == Changer.ChangeMode.SET) {
            if (object instanceof BarStyle) {
                BarStyle barStyle = (BarStyle)object;
                bossBar.setStyle(barStyle);
            }
        } else if (this.pattern == 3) {
            if (mode == Changer.ChangeMode.SET && object instanceof String) {
                String title = (String)object;
                bossBar.setTitle(title);
            } else if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                bossBar.setTitle(null);
            }
        } else if (this.pattern == 4) {
            if (mode == Changer.ChangeMode.RESET) {
                bossBar.setProgress(1.0);
            } else if (object instanceof Number) {
                Number number = (Number)object;
                double newProgress = 0.0;
                double oldProgress = bossBar.getProgress();
                float progress = number.floatValue() / 100.0f;
                if (mode == Changer.ChangeMode.SET) {
                    newProgress = progress;
                } else if (mode == Changer.ChangeMode.ADD) {
                    newProgress = oldProgress + (double)progress;
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    newProgress = oldProgress - (double)progress;
                }
                newProgress = MathUtil.clamp((float)newProgress, 0.0f, 1.0f);
                if (Double.isNaN(newProgress)) {
                    newProgress = 0.0;
                }
                bossBar.setProgress(newProgress);
            }
        } else if (this.pattern == 5) {
            BarFlag barFlag = (BarFlag)this.barFlag.getSingle(event);
            if (barFlag == null) {
                return;
            }
            if (mode == Changer.ChangeMode.SET && object instanceof Boolean) {
                Boolean setter = (Boolean)object;
                if (setter.booleanValue()) {
                    bossBar.addFlag(barFlag);
                } else {
                    bossBar.removeFlag(barFlag);
                }
            } else if (mode == Changer.ChangeMode.REMOVE) {
                bossBar.removeFlag(barFlag);
            }
        } else if (this.pattern == 6 && object instanceof Boolean) {
            Boolean isVisible = (Boolean)object;
            bossBar.setVisible(isVisible.booleanValue());
        }
    }

    public boolean isSingle() {
        return this.pattern != 0;
    }

    @NotNull
    public Class<?> getReturnType() {
        return switch (this.pattern) {
            case 0 -> Player.class;
            case 1 -> SkriptColor.class;
            case 2 -> BarStyle.class;
            case 3 -> String.class;
            case 4 -> Number.class;
            case 5, 6 -> Boolean.class;
            default -> throw new IllegalStateException("Unexpected value: " + this.pattern);
        };
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String prop = switch (this.pattern) {
            case 0 -> "bar players";
            case 1 -> "bar color";
            case 2 -> "bar style";
            case 3 -> "bar title";
            case 4 -> "bar progress";
            case 5 -> "bar flag " + this.barFlag.toString(e, d);
            case 6 -> "bar visibility";
            default -> "null?!?!";
        };
        return prop + " of boss bar " + this.bossBar.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBossBarProperties.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[boss[ ]]bar players of %bossbar%", "[boss[ ]]bar (color|colour) of %bossbar%", "[boss[ ]]bar style of %bossbar%", "[boss[ ]]bar title of %bossbar%", "[boss[ ]]bar progress of %bossbar%", "[boss[ ]]bar flag %bossbarflag% of %bossbar%", "[boss[ ]]bar visibility of %bossbar%"});
    }
}

