/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.bound.Bound;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Bound - Resize")
@Description(value={"Resize a current bound.", "Full will mark the bound to use the lowest/highest points of the world.", "The second pattern will mark as a full bound without changing the locations.", "", "NOTE: World of a bound cannot be changed.", "", "**SPECIAL NOTE**:", "- When using locations = The bound resizing will use the locations you pass thru", "- When using blocks = The bound resizing will extend the x/y/z axes by 1 to fully include those blocks."})
@Examples(value={"resize bound bound with id \"test\" between {_l1} and {_l1}", "resize bound bound with id \"test\" between block at{_l1} and block at {_l1}", "resize full bound bound with id \"test\""})
@Since(value={"2.5.3"})
public class EffBoundResize
extends Effect {
    private Expression<Bound> bound;
    private Expression<?> point1;
    private Expression<?> point2;
    private boolean full;
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.full = matchedPattern == 1 || parseResult.hasTag("full");
        this.bound = exprs[0];
        if (matchedPattern == 0) {
            this.point1 = exprs[1];
            this.point2 = exprs[2];
        }
        this.pattern = matchedPattern;
        return true;
    }

    protected void execute(Event event) {
        Location greater;
        Location lesser;
        Bound bound = (Bound)this.bound.getSingle(event);
        if (bound == null) {
            return;
        }
        if (this.pattern == 1) {
            bound.setFull(true);
            return;
        }
        Object point1 = this.point1.getSingle(event);
        Object point2 = this.point2.getSingle(event);
        if (point1 == null || point2 == null) {
            return;
        }
        boolean usingBlocks = false;
        if (point1 instanceof Location) {
            Location loc1;
            lesser = loc1 = (Location)point1;
        } else if (point1 instanceof Block) {
            Block block1 = (Block)point1;
            lesser = block1.getLocation();
            usingBlocks = true;
        } else {
            return;
        }
        if (point2 instanceof Location) {
            Location loc2;
            greater = loc2 = (Location)point2;
            usingBlocks = false;
        } else if (point2 instanceof Block) {
            Block block2 = (Block)point2;
            greater = block2.getLocation();
        } else {
            return;
        }
        World world = bound.getWorld();
        if (world == null || lesser.getWorld() != world || greater.getWorld() != world) {
            return;
        }
        bound.resize(lesser, greater, usingBlocks);
        if (this.full) {
            bound.setFull(true);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        if (this.pattern == 1) {
            return "resize full bound " + this.bound.toString(e, d);
        }
        String full = this.full ? "full " : "";
        return "resize " + full + "bound " + this.bound.toString(e, d) + " within " + this.point1.toString(e, d) + " and " + this.point2.toString(e, d);
    }

    static {
        Skript.registerEffect(EffBoundResize.class, (String[])new String[]{"resize [:full] bound %bound% (within|between) %block/location% and %block/location%", "resize full bound %bound%"});
    }
}

