/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.bound.Bound;
import java.util.ArrayList;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - Entities")
@Description(value={"Get all of the entities within a bound.", "NOTE: If the chunk in a bound is unloaded, entities will also be unloaded."})
@Examples(value={"set {_b} to bound with id \"my-bound\"", "loop bound entities in {_b}:", "\tif loop-entity is a cow or pig:", "\t\tkill loop-entity"})
@Since(value={"1.15.0"})
public class ExprBoundEntities
extends SimpleExpression<Entity> {
    private Expression<EntityData<?>> entityDatas;
    private Expression<Bound> bounds;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityDatas = exprs[0];
        this.bounds = exprs[1];
        return true;
    }

    @Nullable
    protected Entity[] get(Event event) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Bound bound : (Bound[])this.bounds.getArray(event)) {
            for (EntityData entityData : (EntityData[])this.entityDatas.getArray(event)) {
                Class type = entityData.getType();
                entities.addAll(bound.getEntities(type));
            }
        }
        return entities.toArray(new Entity[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "bound " + this.entityDatas.toString(e, d) + " of " + this.bounds.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBoundEntities.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[(all [[of] the]|the)] bound %*entitydatas% (of|in|within) %bounds%", "[(all [[of] the]|the)] %*entitydatas% (of|in|within) bound[s] %bounds%"});
    }
}

