/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.bound.Bound;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - Full State")
@Description(value={"Get/set whether this bound is a full bound (reaches from lowest to highest points of a world)."})
@Examples(value={"set bound full state of bound with id \"home\" to true"})
@Since(value={"3.8.0"})
public class ExprBoundFullState
extends SimplePropertyExpression<Bound, Boolean> {
    @Nullable
    public Boolean convert(Bound bound) {
        return bound.isFull();
    }

    @Nullable
    public @Nullable Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Bound[] boundArray;
        if (mode == Changer.ChangeMode.SET && delta != null && (boundArray = delta[0]) instanceof Boolean) {
            Boolean full = (Boolean)boundArray;
            for (Bound bound : (Bound[])this.getExpr().getArray(event)) {
                bound.setFull(full);
            }
        }
    }

    @NotNull
    protected String getPropertyName() {
        return "full state";
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    static {
        ExprBoundFullState.register(ExprBoundFullState.class, Boolean.class, (String)"bound full state", (String)"bounds");
    }
}

