/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.bound.Bound;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - Values")
@Description(value={"Get/set/delete custom values for bounds.", "Some objects will be serialized as their type, others will serialize as just a string.", "Numbers/Locations/Booleans/(Offline)Players/Items will be serialized as their type.", "Entities will be serialized as a string version of their UUID.", "All other objects will be serialized as a string.", "All bound values will return a list of the values, all bound keys will return a list of keys for these values.", "Deleting all bound values/keys will clear the list."})
@Examples(value={"set bound value \"king\" of bound with id \"the_garden\" to player", "set {_v} to bound value \"king\" of {_bound}", "delete bound value \"spawn\" of {_bound}", "set {_values::*} to all bound values of bound with id \"ma_bound\"", "set {_keys::*} to all bound keys of bound with id \"look_mah_imma_bound\"", "delete all bound values from bound with id \"now_im_a_sad_valueless_bound\""})
@Since(value={"2.2.0"})
public class ExprBoundValue
extends SimpleExpression<Object> {
    private int pattern;
    private int parseMark;
    private Expression<String> key;
    private Expression<Bound> bound;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.parseMark = parseResult.mark;
        this.key = this.pattern == 0 ? exprs[0] : null;
        this.bound = exprs[this.pattern == 0 ? 1 : 0];
        return true;
    }

    @Nullable
    protected Object[] get(Event event) {
        Bound bound = (Bound)this.bound.getSingle(event);
        if (bound == null) {
            return null;
        }
        if (this.pattern == 0) {
            String key = (String)this.key.getSingle(event);
            if (key != null) {
                Object value = bound.getValue(key);
                if (value instanceof ItemStack) {
                    ItemStack itemStack = (ItemStack)value;
                    value = new ItemType(itemStack);
                }
                return new Object[]{value};
            }
        } else if (this.pattern == 1) {
            if (this.parseMark == 0) {
                return bound.getValues().values().toArray(new Object[0]);
            }
            return bound.getValues().keySet().toArray(new String[0]);
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.pattern == 0 && (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE)) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        if (this.pattern == 1 && mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Bound bound = (Bound)this.bound.getSingle(event);
        if (bound == null) {
            return;
        }
        if (this.pattern == 0 && mode == Changer.ChangeMode.SET) {
            Object changed;
            String key = (String)this.key.getSingle(event);
            if (key == null) {
                return;
            }
            Object object = delta[0];
            if (object instanceof ItemStack || object instanceof Boolean || object instanceof Number || object instanceof String || object instanceof Location) {
                changed = object;
            } else if (object instanceof ItemType) {
                ItemType itemType = (ItemType)object;
                changed = itemType.getRandom();
            } else if (object instanceof OfflinePlayer) {
                OfflinePlayer offlinePlayer = (OfflinePlayer)object;
                changed = offlinePlayer;
            } else if (object instanceof Entity) {
                Entity entity = (Entity)object;
                changed = entity.getUniqueId().toString();
            } else if (object != null) {
                changed = Classes.toString((Object)object);
            } else {
                return;
            }
            bound.setValue(key, changed);
        } else if (mode == Changer.ChangeMode.DELETE) {
            if (this.pattern == 0) {
                String key = (String)this.key.getSingle(event);
                if (key == null) {
                    return;
                }
                bound.deleteValue(key);
            } else if (this.pattern == 1) {
                bound.clearValues();
            }
        }
    }

    public boolean isSingle() {
        return this.pattern == 0;
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        if (this.pattern == 1) {
            String parse = this.parseMark == 0 ? "values" : "keys";
            return "all bound " + parse + " of bound " + this.bound.toString(e, d);
        }
        return "bound value '" + this.key.toString(e, d) + "' of bound " + this.bound.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBoundValue.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"bound value %string% (of|from) %bound%", "all [[of] the] bound (values|1:keys) (of|from) %bound%"});
    }
}

