/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.elements.display.types.Types;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Name(value="DisplayEntity - Scale")
@Description(value={"Represents the transformation scale of a Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display scale of {_display} to vector(5,5,5)"})
@Since(value={"2.8.0"})
public class ExprDisplayScale
extends SimplePropertyExpression<Entity, Vector> {
    @Nullable
    public Vector convert(Entity entity) {
        if (!(entity instanceof Display)) {
            return null;
        }
        Display display = (Display)entity;
        return Types.converToVector(display.getTransformation().getScale());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Vector.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (delta != null && (object = delta[0]) instanceof Vector) {
            Vector vector = (Vector)object;
            Vector3f scale = Types.converToVector3f(vector);
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Display)) continue;
                Display display = (Display)entity;
                Transformation oldTransform = display.getTransformation();
                Vector3f translation = oldTransform.getTranslation();
                Quaternionf leftRotation = oldTransform.getLeftRotation();
                Quaternionf rightRotation = oldTransform.getRightRotation();
                Transformation newTransform = new Transformation(translation, leftRotation, scale, rightRotation);
                display.setTransformation(newTransform);
            }
        }
    }

    @NotNull
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display scale";
    }

    static {
        ExprDisplayScale.register(ExprDisplayScale.class, Vector.class, (String)"display scale", (String)"entities");
    }
}

