/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@Name(value="Quaternion - From Vector")
@Description(value={"Create a quaternion from a vector.", "The XYZ of the vector will represents the degrees the display entity will rotate on the XYZ axis."})
@Examples(value={"set {_q} to quaternion from vector(0,45,0)", "set display right rotation of {_e} to {_q}"})
@Since(value={"3.2.0"})
public class ExprQuaternionFromVector
extends SimpleExpression<Quaternionf> {
    private Expression<Vector> vector;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.vector = exprs[0];
        return true;
    }

    protected Quaternionf @Nullable [] get(Event event) {
        Quaternionf quat = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        Vector vector = (Vector)this.vector.getSingle(event);
        if (vector == null) {
            return null;
        }
        float x = (float)Math.toRadians(vector.getX());
        float y = (float)Math.toRadians(vector.getY());
        float z = (float)Math.toRadians(vector.getZ());
        quat = quat.rotateZYX(x, y, z);
        return new Quaternionf[]{quat};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Quaternionf> getReturnType() {
        return Quaternionf.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "quaterion from " + this.vector.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprQuaternionFromVector.class, Quaternionf.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"quat[ernion] from [vector] %vector%"});
    }
}

