/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Text Opacity")
@Description(value={"Represents the text opacity of a Text Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display text opacity of {_display} to 50"})
@Since(value={"2.8.0"})
public class ExprTextDisplayOpacity
extends SimplePropertyExpression<Entity, Number> {
    @Nullable
    public Number convert(Entity entity) {
        if (entity instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)entity;
            return (int)textDisplay.getTextOpacity();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number num = (Number)object;
            byte opacity = num.byteValue();
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof TextDisplay)) continue;
                TextDisplay textDisplay = (TextDisplay)entity;
                textDisplay.setTextOpacity(opacity);
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "text opacity";
    }

    static {
        ExprTextDisplayOpacity.register(ExprTextDisplayOpacity.class, Number.class, (String)"[display] text opacity", (String)"entities");
    }
}

