/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fastboard.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.fastboard.FastBoardBase;
import com.shanebeestudios.skbee.api.fastboard.FastBoardManager;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="FastBoard - Toggle")
@Description(value={"Toggle a fastboard on or off."})
@Examples(value={"toggle fastboards of all players off", "toggle player's fastboard"})
@Since(value={"1.16.0"})
public class EffFastBoardToggle
extends Effect {
    private Expression<Player> player;
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.player = exprs[0];
        this.pattern = parseResult.mark;
        if (parseResult.hasTag("score")) {
            Skript.warning((String)"'scoreboard' is deprecated, please use 'fastboard' instead.");
        }
        return true;
    }

    protected void execute(Event event) {
        block5: for (Player player : (Player[])this.player.getArray(event)) {
            FastBoardBase<?, ?> board = FastBoardManager.getBoard(player);
            if (board == null) continue;
            switch (this.pattern) {
                case 0: {
                    board.toggle();
                    continue block5;
                }
                case 1: {
                    board.show();
                    continue block5;
                }
                case 2: {
                    board.hide();
                }
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String toggle = switch (this.pattern) {
            case 1 -> " to on";
            case 2 -> " to off";
            default -> "";
        };
        return "toggle scoreboard[s] of " + this.player.toString(e, d) + toggle;
    }

    static {
        Skript.registerEffect(EffFastBoardToggle.class, (String[])new String[]{"toggle [:score|fast]board[s] of %players% [[to ](1:(on|true)|2:(off|false))]", "toggle %players%'[s] [:score|fast]board[s] [[to ](1:(on|true)|2:(off|false))]"});
    }
}

