/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.gameevent.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.world.GenericGameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Game Event - Radius")
@Description(value={"Get/set the radius a game event will broadcast. Requires MC 1.17+"})
@Examples(value={"on game event:", "\tset game event radius to 20"})
@Since(value={"1.14.0"})
public class ExprGameEventRadius
extends SimpleExpression<Number> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(GenericGameEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in a generic game event"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    @Nullable
    protected Number[] get(Event event) {
        if (event instanceof GenericGameEvent) {
            GenericGameEvent gameEvent = (GenericGameEvent)event;
            return new Number[]{gameEvent.getRadius()};
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[]{Number[].class});
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (event instanceof GenericGameEvent) {
            GenericGameEvent gameEvent = (GenericGameEvent)event;
            if (delta != null) {
                int radiusChange = delta[0] instanceof Number ? ((Number)delta[0]).intValue() : 0;
                int radius = gameEvent.getRadius();
                switch (mode) {
                    case SET: {
                        radius = radiusChange;
                        break;
                    }
                    case ADD: {
                        radius += radiusChange;
                        break;
                    }
                    case REMOVE: {
                        radius -= radiusChange;
                        break;
                    }
                    case DELETE: {
                        radius = 0;
                    }
                }
                if (radius < 0) {
                    radius = 0;
                }
                gameEvent.setRadius(radius);
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "game event radius";
    }

    static {
        Skript.registerExpression(ExprGameEventRadius.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"game[ ]event radius"});
    }
}

