/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="ItemComponent - Clear/Reset Components")
@Description(value={"Clear/reset components of an item. Requires Minecraft 1.21+"})
@Examples(value={"clear food component of player's tool", "clear tool component of player's tool", "reset attribute modifier component of player's tool"})
@Since(value={"3.11.0"})
public class EffClearComponent
extends Effect {
    private boolean remove;
    private Expression<DataComponentType> dataTypes;
    private Expression<?> itemTypes;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.remove = !parseResult.hasTag("reset");
        this.dataTypes = exprs[0];
        this.itemTypes = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        DataComponentType[] dataTypes = (DataComponentType[])this.dataTypes.getArray(event);
        ItemUtils.modifyItems(this.itemTypes.getArray(event), itemStack -> {
            for (DataComponentType dataType : dataTypes) {
                if (this.remove) {
                    itemStack.unsetData(dataType);
                    continue;
                }
                itemStack.resetData(dataType);
            }
        });
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return new SyntaxStringBuilder(e, d).append((Object)(this.remove ? "remove" : "reset")).append(this.dataTypes).append((Object)"component[s] of").append(this.itemTypes).toString();
    }

    static {
        Skript.registerEffect(EffClearComponent.class, (String[])new String[]{"(clear|remove|unset|:reset) %datacomponenttypes% (item|data) component[s] of %itemstacks/itemtypes/slots%"});
    }
}

