/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.EffectSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.DeathProtection;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - Death Protection Component Apply")
@Description(value={"Apply a death protection component to an item.", "If present, this item protects the holder from dying by restoring a single health point.", "Requires Paper 1.21.3+", "See [**Death Protection Component**](https://minecraft.wiki/w/Data_component_format#death_protection) on McWiki for more info.", "`death_effect` = A `consume effect` to by applied to the component (supports a list) [Optional].", "`death_effects` = A section to apply `consume effects` [Optional]."})
@Examples(value={"set {_p::1} to potion effect of night vision for 10 seconds", "set {_p::2} to potion effect of slow mining for 5 seconds", "set {_effects} to apply_effects({_p::*}, 0.5)", "", "set {_i} to 1 of stick", "apply death protection component to {_i}:", "\tdeath_effects: {_effects}", "give {_i} to player", "", "apply death protection to {_i}:", "\tdeath_effects:", "\t\tapply -> potion effect of slowness for 10 seconds with probability 0.5", "\t\tapply -> clear all effects", "\t\tapply -> remove effects night vision", "\t\tapply -> play sound \"blah.blah\"", "\t\tapply -> teleport randomly within 15", "\t\tapply -> teleport randomly within 20 meters", "\t\tapply -> teleport randomly within 100 blocks"})
@Since(value={"3.8.0"})
public class SecDeathProtectionComponent
extends EffectSection {
    private static final EntryValidator VALIDATOR = SimpleEntryValidator.builder().addOptionalEntry("death_effect", ConsumeEffect.class).addOptionalSection("death_effects").build();
    private Expression<Object> items;
    private Expression<ConsumeEffect> effect;
    private Trigger effectsSection;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> triggerItems) {
        this.items = exprs[0];
        if (sectionNode == null) {
            return true;
        }
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.effect = (Expression)container.getOptional("death_effect", false);
        SectionNode node = (SectionNode)container.getOptional("death_effects", SectionNode.class, false);
        if (node != null) {
            this.effectsSection = this.loadCode(node, "death_effects", new Class[]{DeathProtectionEvent.class});
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        DeathProtection.Builder builder = DeathProtection.deathProtection();
        if (this.effect != null) {
            for (ConsumeEffect consumeEffect : (ConsumeEffect[])this.effect.getArray(event)) {
                builder.addEffect(consumeEffect);
            }
        }
        if (this.effectsSection != null) {
            DeathProtectionEvent deathProtectionEvent = new DeathProtectionEvent(builder);
            Variables.setLocalVariables((Event)deathProtectionEvent, (Object)Variables.copyLocalVariables((Event)event));
            Trigger.walk((TriggerItem)this.effectsSection, (Event)deathProtectionEvent);
            Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)deathProtectionEvent));
            Variables.copyLocalVariables((Event)deathProtectionEvent);
        }
        DeathProtection deathProtection = (DeathProtection)builder.build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> itemStack.setData(DataComponentTypes.DEATH_PROTECTION, (Object)deathProtection));
        return super.walk(event, false);
    }

    public String toString(Event e, boolean d) {
        return "apply death protection component to " + this.items.toString(e, d);
    }

    static {
        Skript.registerSection(SecDeathProtectionComponent.class, (String[])new String[]{"apply death protection [component] to %itemstacks/itemtypes/slots%"});
    }

    public static class DeathProtectionEvent
    extends Event {
        private final DeathProtection.Builder builder;

        public DeathProtectionEvent(DeathProtection.Builder builder) {
            this.builder = builder;
        }

        public DeathProtection.Builder getDeathProtectionBuilder() {
            return this.builder;
        }

        @NotNull
        public HandlerList getHandlers() {
            throw new IllegalStateException("DeathProtectionEvent should never be called");
        }
    }
}

