/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Item with NBT")
@Description(value={"Get an item with nbt.", "NOTE: The NBT in the examples represents NBT for Minecraft 1.20.5+", "NOTE: The optional `custom` syntax will place nbt in the `\"minecraft:custom_data\"` component (1.20.5+ only)."})
@Examples(value={"give player diamond sword with nbt from \"{\"\"minecraft:food\"\":{nutrition:10,saturation:2.0f}}\"", "set {_n} to nbt from \"{custom_data:{points:10}}\"", "set {_i} to netherite axe with nbt {_n}", "give player diamond pickaxe with nbt from \"{\"\"minecraft:damage\"\":500}\"", "give player 30 apples with nbt from \"{\"\"minecraft:max_stack_size\"\":10}\"", "", "#These two have the same outcome, just showing the use of `custom` and how it places in the custom_data component.", "give player diamond sword with nbt from \"{\"\"minecraft:custom_data\"\":{points:10}}\"", "give player diamond sword with custom nbt from \"{points:10}\""})
@Since(value={"1.0.0"})
public class ExprItemWithNBT
extends SimpleExpression<ItemType> {
    private Expression<ItemType> item;
    private Expression<NBTCompound> nbt;
    private boolean custom;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.item = exprs[0];
        this.nbt = exprs[1];
        this.custom = parseResult.hasTag("custom");
        return true;
    }

    protected ItemType @Nullable [] get(Event event) {
        ItemType item = (ItemType)this.item.getSingle(event);
        NBTCompound nbt = (NBTCompound)this.nbt.getSingle(event);
        if (item == null || nbt == null) {
            return null;
        }
        Material material = item.getMaterial();
        if (!material.isItem()) {
            this.warning("Cannot add nbt to a non-item (block only) itemtype: " + Classes.toString((Object)item));
            return null;
        }
        if (material == Material.AIR || item.getAmount() < 1) {
            this.warning("Cannot add nbt to an empty/air item: " + Classes.toString((Object)item));
            return null;
        }
        return new ItemType[]{NBTApi.getItemTypeWithNBT(item, nbt, this.custom)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String custom = this.custom ? " custom " : " ";
        return this.item.toString(e, d) + " with" + custom + "nbt " + this.nbt.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprItemWithNBT.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"%itemtype% with [:custom] [[item( |-)]nbt] %nbtcompound%"});
    }
}

