/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.reflection.ChatReflection;
import com.shanebeestudios.skbee.api.skript.base.PropertyExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Pretty NBT String")
@Description(value={"Get a 'pretty' NBT string. This is colored the same as when using the vanilla Minecraft '/data' command. ", "Splitting it will output kind of like a JSON output. Requires 1.13.2+"})
@Examples(value={"set {_pretty} to pretty nbt from nbt compound of player's tool", "send pretty nbt from nbt compound of player's tool", "set {_nbt} to nbt of player's tool", "send pretty nbt from {_nbt} to player", "send pretty nbt from {_nbt} with split \" \" to console"})
@Since(value={"1.6.0"})
public class ExprPrettyNBT
extends PropertyExpression<Object, String> {
    private Expression<String> split;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.split = exprs[1];
        return true;
    }

    protected String[] get(Event event, Object[] source) {
        String split = this.split != null ? (String)this.split.getSingle(event) : null;
        return (String[])this.get(source, object -> {
            if (object instanceof NBTCompound) {
                NBTCompound compound = (NBTCompound)object;
                return ChatReflection.getPrettyNBT(compound, split);
            }
            return null;
        });
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "pretty nbt from " + this.getExpr().toString(e, d) + (String)(this.split != null ? " with split " + this.split.toString(e, d) : "");
    }

    static {
        Skript.registerExpression(ExprPrettyNBT.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"pretty nbt (of|from) %nbtcompounds% [(with|using) split %-string%]", "%nbtcompounds%'[s] pretty nbt [(with|using) split %-string%]"});
    }
}

