/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.DocumentationId;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SectionExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.elements.nbt.sections.SecModifyNBT;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Empty Compound")
@Description(value={"Returns an empty/new NBT compound.", "Optionally you can define this as a section to modify the created nbt compound directly"})
@Examples(value={"set {_nbt} to blank nbt compound", "set tag \"points\" of {_nbt} to 10", "", "set {_data} to empty nbt compound:", "\tset string tag \"name\" of nbt to \"Jimmy\"", "\tset int tag \"points\" of nbt to 99", "\tset compound tag \"extra\" of nbt to empty nbt compound"})
@Since(value={"2.8.0"})
@DocumentationId(value="ExprBlankNBTCompound")
public class SecExprBlankNBTCompound
extends SectionExpression<NBTCompound> {
    @Nullable
    private Trigger trigger;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (sectionNode != null) {
            AtomicBoolean delayed = new AtomicBoolean(false);
            Runnable afterLoading = () -> delayed.set(!this.getParser().getHasDelayBefore().isFalse());
            this.trigger = this.loadCode(sectionNode, "empty nbt modify", afterLoading, new Class[]{SecModifyNBT.NBTEditEvent.class});
            if (delayed.get()) {
                Skript.error((String)"Delays can't be used within an Empty NBT Modify Section");
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected NBTCompound[] get(Event event) {
        NBTContainer nbtCompound = new NBTContainer();
        if (this.trigger != null) {
            SecModifyNBT.NBTEditEvent nbtEditEvent = new SecModifyNBT.NBTEditEvent(nbtCompound);
            Variables.withLocalVariables((Event)event, (Event)nbtEditEvent, () -> TriggerItem.walk((TriggerItem)this.trigger, (Event)nbtEditEvent));
        }
        return new NBTCompound[]{nbtCompound};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends NBTCompound> getReturnType() {
        return NBTCompound.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "blank nbt compound";
    }

    static {
        Skript.registerExpression(SecExprBlankNBTCompound.class, NBTCompound.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a[n]] (blank|empty|new) nbt compound"});
    }
}

