/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Is Critical Hit")
@Description(value={"Check if a hit was a critical hit in a damage event. Requires a PaperMC server."})
@Examples(value={"on damage:", "\tif attacker is a player:", "\t\tif hit is critical:", "\t\t\tcancel event"})
@Since(value={"2.8.3"})
public class CondCriticalHit
extends Condition {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.methodExists(EntityDamageByEntityEvent.class, (String)"isCritical", (Class[])new Class[0])) {
            Skript.error((String)"'hit is critical' requires a PaperMC server.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (!ParserInstance.get().isCurrentEvent(EntityDamageEvent.class)) {
            Skript.error((String)"'hit is critical' is only available in an entity damage event!", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.setNegated(parseResult.hasTag("1"));
        return true;
    }

    public boolean check(Event event) {
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)event;
            return this.isNegated() != entityEvent.isCritical();
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String neg = this.isNegated() ? "isn't" : "is";
        return "hit " + neg + " critical";
    }

    static {
        Skript.registerCondition(CondCriticalHit.class, (String[])new String[]{"hit (is|1:(isn't|is not)) [a] critical"});
    }
}

