/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Refresh Chunk")
@Description(value={"Resends chunks to the clients. This is useful if you change a biome and need to refresh the client.", "The two numbers represent a chunk's X/Y coords, NOT a location. A chunk's X/Y coords are basically", "a location divided by 16. Ex: Chunk 1/1 would be at location X=16, Z=16."})
@Examples(value={"set biome of block at player to plains", "refresh chunk at player", "refresh chunk at 1,1 in world \"world\""})
@Since(value={"3.4.0"})
public class EffChunkRefresh
extends Effect {
    private int pattern;
    private Expression<Chunk> chunks;
    private Expression<Number> x;
    private Expression<Number> z;
    private Expression<World> world;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (matchedPattern == 0) {
            this.chunks = exprs[0];
        } else {
            this.x = exprs[0];
            this.z = exprs[1];
            this.world = exprs[2];
        }
        return true;
    }

    protected void execute(Event event) {
        if (this.pattern == 0) {
            for (Chunk chunk : (Chunk[])this.chunks.getArray(event)) {
                World world = chunk.getWorld();
                world.refreshChunk(chunk.getX(), chunk.getZ());
            }
        } else {
            Number x = (Number)this.x.getSingle(event);
            Number z = (Number)this.z.getSingle(event);
            World world = (World)this.world.getSingle(event);
            if (x == null || z == null || world == null) {
                return;
            }
            world.refreshChunk(x.intValue(), z.intValue());
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        if (this.pattern == 0) {
            return "refresh chunk[s] " + this.chunks.toString(e, d);
        }
        String x = this.x.toString(e, d);
        String z = this.z.toString(e, d);
        String w = this.world.toString(e, d);
        return String.format("refresh chunk at %s,%s in %s", x, z, w);
    }

    static {
        Skript.registerEffect(EffChunkRefresh.class, (String[])new String[]{"refresh [chunk[s]] %chunks%", "refresh chunk at %number%,[ ]%number% (in|of) [world] %world%"});
    }
}

