/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

@Name(value="Dispatch Command")
@Description(value={"Similar to Skript's command effect, with the option to use any command sender", "(vs. being restricted to only player/console), and the option to temporarily attach a permission.", "The attached permission will only last for 1 tick, and automatically remove. This is not persistent."})
@Examples(value={"dispatch player command \"give %player% stick\" with permission \"minecraft.command.give\"", "dispatch (random element of all mobs) command \"/tell %player% hi\""})
@Since(value={"3.10.0"})
public class EffDispatchCommand
extends Effect {
    private static final SkBee PLUGIN = SkBee.getPlugin();
    private Expression<CommandSender> commandSender;
    private Expression<String> command;
    private Expression<String> permission;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.commandSender = exprs[0];
        this.command = exprs[1];
        this.permission = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        CommandSender commandSender = (CommandSender)this.commandSender.getSingle(event);
        String command = (String)this.command.getSingle(event);
        if (commandSender == null || command == null) {
            return;
        }
        if (this.permission != null) {
            String permission = (String)this.permission.getSingle(event);
            if (permission == null) {
                return;
            }
            commandSender.addAttachment((Plugin)PLUGIN, permission, true, 1);
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        Bukkit.dispatchCommand((CommandSender)commandSender, (String)command);
    }

    public String toString(@Nullable Event e, boolean d) {
        String perm = this.permission == null ? "" : " with permission " + (String)this.permission.getSingle(e);
        return new SyntaxStringBuilder(e, d).append(new Object[]{"dispatch", this.commandSender, "command", this.command}).append((Object)perm).toString();
    }

    static {
        Skript.registerEffect(EffDispatchCommand.class, (String[])new String[]{"dispatch %commandsender% command %string% [with permission %-string%]"});
    }
}

