/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Drop Held Item")
@Description(value={"Forces the player to drop their currently held item.", "By default it will drop one of their held item, or you can optionally drop the whole stack."})
@Examples(value={"make player drop all of held item", "force all players to drop all of their held items"})
@Since(value={"1.17.0"})
public class EffDropItem
extends Effect {
    private Expression<Player> players;
    private boolean all;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.all = parseResult.hasTag("all");
        return true;
    }

    protected void execute(Event event) {
        for (Player player : (Player[])this.players.getArray(event)) {
            if (!player.dropItem(this.all)) continue;
            player.updateInventory();
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String all = this.all ? " all of" : "";
        return "make " + this.players.toString(e, d) + " drop" + all + " held item";
    }

    static {
        Skript.registerEffect(EffDropItem.class, (String[])new String[]{"(make|force) %players% [to] drop [all:all of] [their] held item[s]"});
    }
}

